/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedContainer<E>,
Cloneable {
    private static final long serialVersionUID = 1999408533884863599L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> type) {
        this.type = type;
        ArgumentChecks.ensureNonNull("type", type);
    }

    public CheckedHashSet(Class<E> type, int capacity) {
        super(capacity);
        this.type = type;
        ArgumentChecks.ensureNonNull("type", type);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    protected void ensureValid(E element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format((short)43, "element", this.type, element.getClass()));
        }
    }

    private void ensureValidCollection(Collection<? extends E> collection) throws IllegalArgumentException {
        for (E element : collection) {
            this.ensureValid(element);
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        assert (Thread.holdsLock(this.getLock()));
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.getLock();
        synchronized (object) {
            return new Iter(super.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(element);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidCollection(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashSet<E> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashSet)super.clone();
        }
    }

    private final class Iter
    implements Iterator<E> {
        private final Iterator<E> iterator;

        Iter(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = CheckedHashSet.this.getLock();
            synchronized (object) {
                return this.iterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() throws NoSuchElementException {
            Object object = CheckedHashSet.this.getLock();
            synchronized (object) {
                return this.iterator.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() throws UnsupportedOperationException {
            Object object = CheckedHashSet.this.getLock();
            synchronized (object) {
                CheckedHashSet.this.checkWritePermission();
                this.iterator.remove();
            }
        }
    }
}

