/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import org.apache.sis.measure.NumberRange;

public class CollectionChangeEvent<T>
extends EventObject {
    private static final long serialVersionUID = 4003873381282325130L;
    public static final int ITEM_ADDED = 1;
    public static final int ITEM_REMOVED = 2;
    public static final int ITEM_CHANGED = 3;
    private final NumberRange range;
    private final int type;
    private final Collection<T> items;
    private final EventObject subEvent;

    public CollectionChangeEvent(Object source, T item, int type, NumberRange range, EventObject event) {
        this(source, (Collection<T>)Collections.singleton(item), type, range, event);
    }

    public CollectionChangeEvent(Object source, Collection<? extends T> items, int type, NumberRange range, EventObject event) {
        super(source);
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException("invalide type");
        }
        this.range = range;
        this.type = type;
        this.items = Collections.unmodifiableCollection(new ArrayList<T>(items));
        this.subEvent = event;
    }

    public NumberRange getRange() {
        return this.range;
    }

    public int getType() {
        return this.type;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public EventObject getChangeEvent() {
        return this.subEvent;
    }
}

