/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.sis.measure.NumberRange;
import org.geotoolkit.util.collection.CheckedArrayList;

public abstract class NotifiedCheckedList<E>
extends CheckedArrayList<E> {
    public NotifiedCheckedList(Class<E> type) {
        super(type);
    }

    public NotifiedCheckedList(Class<E> type, int capacity) {
        super(type, capacity);
    }

    protected abstract void notifyAdd(E var1, int var2);

    protected abstract void notifyAdd(Collection<? extends E> var1, NumberRange<Integer> var2);

    protected abstract void notifyChange(E var1, E var2, int var3);

    protected abstract void notifyRemove(E var1, int var2);

    protected abstract void notifyRemove(Collection<? extends E> var1, NumberRange<Integer> var2);

    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        if (element == null) {
            return false;
        }
        boolean added = super.add(element);
        if (added) {
            int index = super.size() - 1;
            this.notifyAdd(element, index);
        }
        return added;
    }

    @Override
    public void add(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        super.add(index, element);
        this.notifyAdd(element, index);
    }

    @Override
    public E set(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        E old = super.set(index, element);
        this.notifyChange(old, element, index);
        return old;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        int startIndex = super.size();
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyAdd(collection, NumberRange.create(startIndex, true, super.size() - 1, true));
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        boolean added = super.addAll(index, collection);
        if (added) {
            this.notifyAdd(collection, NumberRange.create(index, true, index + collection.size(), true));
        }
        return added;
    }

    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        int index = super.indexOf(o);
        if (index >= 0) {
            super.remove(index);
            this.notifyRemove(super.getElementType().cast(o), index);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) throws UnsupportedOperationException {
        Object removed = super.remove(index);
        this.notifyRemove(removed, index);
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        boolean valid = false;
        for (Object i : c) {
            boolean val = this.remove(i);
            if (!val) continue;
            valid = val;
        }
        return valid;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        if (!this.isEmpty()) {
            ArrayList copy = new ArrayList(this);
            NumberRange<Integer> range = NumberRange.create(0, true, copy.size() - 1, true);
            super.clear();
            this.notifyRemove(copy, range);
        }
    }
}

