/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.dom;

import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.geotoolkit.util.DomUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

public class LazyLoadElement
implements Element {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.util.dom");
    private final Path xmlFile;
    private volatile Element element;
    private volatile boolean loaded = false;

    public LazyLoadElement(Path xmlFile) {
        this.xmlFile = xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getElement() {
        if (!this.loaded) {
            LazyLoadElement lazyLoadElement = this;
            synchronized (lazyLoadElement) {
                if (!this.loaded) {
                    try {
                        Document doc = DomUtilities.read(this.xmlFile);
                        this.element = doc.getDocumentElement();
                    }
                    catch (IOException | ParserConfigurationException | SAXException ex) {
                        LOGGER.log(Level.WARNING, "Unable to load file : " + this.xmlFile, ex);
                    }
                    this.loaded = true;
                }
            }
        }
        return this.element;
    }

    @Override
    public String getTagName() {
        Element elem = this.getElement();
        return elem != null ? elem.getTagName() : null;
    }

    @Override
    public String getAttribute(String name) {
        Element elem = this.getElement();
        return elem != null ? elem.getAttribute(name) : null;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setAttribute(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.removeAttribute(name);
        }
    }

    @Override
    public Attr getAttributeNode(String name) {
        Element elem = this.getElement();
        return elem != null ? elem.getAttributeNode(name) : null;
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.setAttributeNode(newAttr) : null;
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.removeAttributeNode(oldAttr) : null;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        Element elem = this.getElement();
        return elem != null ? elem.getElementsByTagName(name) : null;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.getAttributeNS(namespaceURI, localName) : null;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setAttributeNS(namespaceURI, qualifiedName, value);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.removeAttributeNS(namespaceURI, localName);
        }
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.getAttributeNodeNS(namespaceURI, localName) : null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.setAttributeNodeNS(newAttr) : null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.getElementsByTagNameNS(namespaceURI, localName) : null;
    }

    @Override
    public boolean hasAttribute(String name) {
        Element elem = this.getElement();
        return elem != null ? elem.hasAttribute(name) : Boolean.FALSE.booleanValue();
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.hasAttributeNS(namespaceURI, localName) : Boolean.FALSE.booleanValue();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        Element elem = this.getElement();
        return elem != null ? elem.getSchemaTypeInfo() : null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setIdAttribute(name, isId);
        }
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setIdAttributeNS(namespaceURI, localName, isId);
        }
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setIdAttributeNode(idAttr, isId);
        }
    }

    @Override
    public String getNodeName() {
        Element elem = this.getElement();
        return elem != null ? elem.getNodeName() : null;
    }

    @Override
    public String getNodeValue() throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.getNodeValue() : null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setNodeValue(nodeValue);
        }
    }

    @Override
    public short getNodeType() {
        Element elem = this.getElement();
        return elem != null ? elem.getNodeType() : (short)1;
    }

    @Override
    public Node getParentNode() {
        Element elem = this.getElement();
        return elem != null ? elem.getParentNode() : null;
    }

    @Override
    public NodeList getChildNodes() {
        Element elem = this.getElement();
        return elem != null ? elem.getChildNodes() : null;
    }

    @Override
    public Node getFirstChild() {
        Element elem = this.getElement();
        return elem != null ? elem.getFirstChild() : null;
    }

    @Override
    public Node getLastChild() {
        Element elem = this.getElement();
        return elem != null ? elem.getLastChild() : null;
    }

    @Override
    public Node getPreviousSibling() {
        Element elem = this.getElement();
        return elem != null ? elem.getPreviousSibling() : null;
    }

    @Override
    public Node getNextSibling() {
        Element elem = this.getElement();
        return elem != null ? elem.getNextSibling() : null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        Element elem = this.getElement();
        return elem != null ? elem.getAttributes() : null;
    }

    @Override
    public Document getOwnerDocument() {
        Element elem = this.getElement();
        return elem != null ? elem.getOwnerDocument() : null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.insertBefore(newChild, refChild) : null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.replaceChild(newChild, oldChild) : null;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.removeChild(oldChild) : null;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.appendChild(newChild) : null;
    }

    @Override
    public boolean hasChildNodes() {
        Element elem = this.getElement();
        return elem != null ? elem.hasChildNodes() : Boolean.FALSE.booleanValue();
    }

    @Override
    public Node cloneNode(boolean deep) {
        Element elem = this.getElement();
        return elem != null ? elem.cloneNode(deep) : null;
    }

    @Override
    public void normalize() {
        Element elem = this.getElement();
        if (elem != null) {
            elem.normalize();
        }
    }

    @Override
    public boolean isSupported(String feature, String version) {
        Element elem = this.getElement();
        return elem != null ? elem.isSupported(feature, version) : Boolean.FALSE.booleanValue();
    }

    @Override
    public String getNamespaceURI() {
        Element elem = this.getElement();
        return elem != null ? elem.getNamespaceURI() : null;
    }

    @Override
    public String getPrefix() {
        Element elem = this.getElement();
        return elem != null ? elem.getPrefix() : null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setPrefix(prefix);
        }
    }

    @Override
    public String getLocalName() {
        Element elem = this.getElement();
        return elem != null ? elem.getLocalName() : null;
    }

    @Override
    public boolean hasAttributes() {
        Element elem = this.getElement();
        return elem != null ? elem.hasAttributes() : Boolean.FALSE.booleanValue();
    }

    @Override
    public String getBaseURI() {
        Element elem = this.getElement();
        return elem != null ? elem.getBaseURI() : null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.compareDocumentPosition(other) : (short)0;
    }

    @Override
    public String getTextContent() throws DOMException {
        Element elem = this.getElement();
        return elem != null ? elem.getTextContent() : null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        Element elem = this.getElement();
        if (elem != null) {
            elem.setTextContent(textContent);
        }
    }

    @Override
    public boolean isSameNode(Node other) {
        Element elem = this.getElement();
        return elem != null ? elem.isSameNode(other) : Boolean.FALSE.booleanValue();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        Element elem = this.getElement();
        return elem != null ? elem.lookupPrefix(namespaceURI) : null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        Element elem = this.getElement();
        return elem != null ? elem.isDefaultNamespace(namespaceURI) : Boolean.FALSE.booleanValue();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        Element elem = this.getElement();
        return elem != null ? elem.lookupNamespaceURI(prefix) : null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        Element elem = this.getElement();
        return elem != null ? elem.isEqualNode(arg) : Boolean.FALSE.booleanValue();
    }

    @Override
    public Object getFeature(String feature, String version) {
        Element elem = this.getElement();
        return elem != null ? elem.getFeature(feature, version) : null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        Element elem = this.getElement();
        return elem != null ? elem.setUserData(key, data, handler) : null;
    }

    @Override
    public Object getUserData(String key) {
        Element elem = this.getElement();
        return elem != null ? elem.getUserData(key) : null;
    }
}

