/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jaxb.TypeRegistration;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.MarshallerPool;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.XLink;
import org.geotoolkit.resources.Errors;

public class AnchoredMarshallerPool
extends MarshallerPool {
    private final String schemaLocation;
    private final Map<String, URI> anchors;

    public AnchoredMarshallerPool() throws JAXBException {
        this(TypeRegistration.getSharedContext());
    }

    public AnchoredMarshallerPool(JAXBContext context) throws JAXBException {
        this(context, null, new HashMap<String, URI>(), null);
    }

    public AnchoredMarshallerPool(JAXBContext context, Map<String, Object> properties) throws JAXBException {
        this(context, null, new HashMap<String, URI>(), properties);
    }

    public AnchoredMarshallerPool(Class<?> ... classesToBeBound) throws JAXBException {
        this((String)null, classesToBeBound);
    }

    public AnchoredMarshallerPool(String schemaLocation, Class<?> ... classesToBeBound) throws JAXBException {
        this(JAXBContext.newInstance(classesToBeBound), schemaLocation, new HashMap<String, URI>(), null);
    }

    public AnchoredMarshallerPool(String packages) throws JAXBException {
        this(packages, (String)null);
    }

    public AnchoredMarshallerPool(String packages, String schemaLocation) throws JAXBException {
        this(JAXBContext.newInstance(packages), schemaLocation, new HashMap<String, URI>(), null);
    }

    private AnchoredMarshallerPool(JAXBContext context, String schemaLocation, Map<String, URI> anchors, Map<String, Object> properties) throws JAXBException {
        super(context, AnchoredMarshallerPool.getProperties(anchors, properties));
        this.schemaLocation = schemaLocation;
        this.anchors = anchors;
    }

    private static Map<String, Object> getProperties(final Map<String, URI> anchors, Map<String, Object> previousProperties) {
        Map<String, Object> properties = previousProperties != null ? previousProperties : new HashMap<String, Object>();
        properties.put("org.apache.sis.xml.resolver", new ReferenceResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public XLink anchor(MarshalContext context, Object value, CharSequence text) {
                URI linkage;
                Map map = anchors;
                synchronized (map) {
                    linkage = (URI)anchors.get(value);
                }
                if (linkage != null) {
                    XLink xlink = new XLink();
                    xlink.setHRef(linkage);
                    return xlink;
                }
                return super.anchor(context, value, text);
            }
        });
        return properties;
    }

    @Override
    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = super.createMarshaller();
        if (this.schemaLocation != null) {
            marshaller.setProperty("jaxb.schemaLocation", this.schemaLocation);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnchor(String label, URI linkage) throws IllegalStateException {
        Map<String, URI> map = this.anchors;
        synchronized (map) {
            URI old = this.anchors.put(label, linkage);
            if (old != null) {
                this.anchors.put(label, old);
                throw new IllegalStateException(Errors.format((short)211, label));
            }
        }
    }
}

