/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.stubbing.answers.InvocationInfo;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.ValidableAnswer;

public abstract class AbstractThrowsException
implements Answer<Object>,
ValidableAnswer {
    private final ConditionalStackTraceFilter filter = new ConditionalStackTraceFilter();

    protected abstract Throwable getThrowable();

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Throwable throwable = this.getThrowable();
        if (throwable == null) {
            throw new IllegalStateException("throwable is null: you shall not call #answer if #validateFor fails!");
        }
        if (MockUtil.isMock(throwable)) {
            throw throwable;
        }
        Throwable t2 = throwable.fillInStackTrace();
        if (t2 == null) {
            throw throwable;
        }
        this.filter.filter(t2);
        throw t2;
    }

    @Override
    public void validateFor(InvocationOnMock invocation) {
        Throwable throwable = this.getThrowable();
        if (throwable == null) {
            throw Reporter.cannotStubWithNullThrowable();
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return;
        }
        if (!new InvocationInfo(invocation).isValidException(throwable)) {
            throw Reporter.checkedExceptionInvalid(throwable);
        }
    }
}

