/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data;

import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class XMLSchemaValidationTests
extends DataFixture {
    private Schema appSchema;

    @BeforeClass
    public void getXMLSchema(ITestContext testContext) {
        this.appSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMA.getName());
    }

    @Test(description="See ISO 19136: A.3.4")
    public void isXMLSchemaValid() throws SAXException {
        Validator validator = this.appSchema.newValidator();
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(new StreamSource(this.dataFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }
}

