/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.util.GmlVersion;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class XMLSchemaTests {
    static final long COMPILE_TIMEOUT = 60000L;
    private final Logger logr = Logger.getLogger(this.getClass().getPackage().getName());
    private static final String ETS_ROOT_PKG = "/org/opengis/cite/iso19136/";
    private Set<URI> xsdLocations;

    @BeforeClass
    public void getSchemaURIsFromTestContext(ITestContext testContext) {
        Object uriSet = testContext.getSuite().getAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName());
        if (null == uriSet || !Set.class.isAssignableFrom(uriSet.getClass())) {
            throw new MissingResourceException("Unable to obtain XML Schema locations from ITestContext", SuiteAttribute.SCHEMA_LOC_SET.getType().getName(), SuiteAttribute.SCHEMA_LOC_SET.getName());
        }
        this.xsdLocations = (Set)uriSet;
    }

    @Test(description="See ISO 19136: A.1.1.4", timeOut=60000L)
    public void compileXMLSchema(ITestContext testContext) throws SAXException, IOException {
        this.logr.log(Level.INFO, "Compiling schemas...\n" + this.xsdLocations);
        String version = (String)testContext.getSuite().getAttribute(SuiteAttribute.VERSION.getName());
        GmlVersion gmlVersion = GmlVersion.V322;
        try {
            gmlVersion = GmlVersion.fromString(version);
        }
        catch (IllegalArgumentException e) {
            this.logr.info("No GML version was provided. Version 3.2.2 will be used.");
        }
        URL entityCatalog = null;
        switch (gmlVersion) {
            case V321: {
                entityCatalog = this.getClass().getResource("/org/opengis/cite/iso19136/schema-catalog-gml-3.2.1.xml");
                break;
            }
            case V322: {
                entityCatalog = this.getClass().getResource("/org/opengis/cite/iso19136/schema-catalog.xml");
                break;
            }
            default: {
                entityCatalog = this.getClass().getResource("/org/opengis/cite/iso19136/schema-catalog.xml");
            }
        }
        Assert.assertNotNull(entityCatalog, "Could not create EntityCatalog URI for Version: " + gmlVersion);
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(entityCatalog);
        Schema schema = xsdCompiler.compileXmlSchema(this.xsdLocations.toArray(new URI[this.xsdLocations.size()]));
        Assert.assertNotNull(schema, ErrorMessage.format("SchemaError", this.xsdLocations));
        ValidationErrorHandler errHandler = xsdCompiler.getErrorHandler();
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("XMLSchemaNotValid", errHandler.getErrorCount(), errHandler.toString()));
        if (null != schema) {
            testContext.getSuite().setAttribute(SuiteAttribute.SCHEMA.getName(), schema);
        }
    }

    void setSchemaLocations(Set<URI> schemaURIs) {
        this.xsdLocations = schemaURIs;
    }
}

