/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.quality;

import java.util.Collection;
import java.util.Collections;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.Description;
import org.opengis.metadata.quality.Measure;
import org.opengis.metadata.quality.MeasureReference;
import org.opengis.util.InternationalString;

final class MeasureInstanceReference
implements MeasureReference {
    private final Measure measure;

    MeasureInstanceReference(Measure measure) {
        this.measure = measure;
    }

    @Override
    public Identifier getMeasureIdentification() {
        return this.measure.getMeasureIdentifier();
    }

    @Override
    public Collection<? extends InternationalString> getNamesOfMeasure() {
        InternationalString internationalString = this.measure.getName();
        return internationalString != null ? Collections.singletonList(internationalString) : Collections.emptyList();
    }

    @Override
    public InternationalString getMeasureDescription() {
        Description description;
        InternationalString internationalString = this.measure.getDefinition();
        if (internationalString == null && (description = this.measure.getDescription()) != null) {
            internationalString = description.getTextDescription();
        }
        return internationalString;
    }

    public boolean equals(Object object) {
        return object instanceof MeasureInstanceReference && this.measure.equals(((MeasureInstanceReference)object).measure);
    }

    public int hashCode() {
        return this.measure.hashCode() ^ 0xD1210041;
    }

    public String toString() {
        Comparable<InternationalString> comparable;
        String string = null;
        Identifier identifier = this.getMeasureIdentification();
        if (identifier != null) {
            string = identifier.getCode();
        }
        if (string == null && (comparable = this.measure.getName()) != null) {
            string = comparable.toString();
        }
        comparable = new StringBuilder("MeasureReference");
        if (string != null) {
            ((StringBuilder)comparable).append("[\"").append(string).append("\"]");
        } else {
            ((StringBuilder)comparable).append("[]");
        }
        return ((StringBuilder)comparable).toString();
    }
}

