/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.factory.SerializedKey;
import org.opengis.util.InternationalString;

public class Hints
extends RenderingHints {
    public static final ClassKey CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
    public static final ClassKey CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
    public static final ClassKey DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
    public static final ClassKey MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
    public static final Key DEFAULT_COORDINATE_REFERENCE_SYSTEM = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final Key SAMPLE_DIMENSION_TYPE = new Key("org.geotoolkit.coverage.SampleDimensionType");
    public static final ClassKey FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
    public static final ClassKey STYLE_FACTORY = new ClassKey("org.opengis.style.StyleFactory");
    public static final Key UPDATE_ID_ON_INSERT = new Key(Boolean.class);
    public static final Key PROPERTY_IS_IDENTIFIER = new Key(Boolean.class);
    public static final Key KEY_IGNORE_SMALL_FEATURES = new Key(double[].class);

    public Hints() {
        super(null);
    }

    public Hints(RenderingHints.Key key, Object value) {
        this();
        this.put(key, value);
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2) {
        this(key1, value1);
        this.put(key2, value2);
    }

    public Hints(Map<? extends RenderingHints.Key, ?> hints) {
        this();
        if (hints != null) {
            this.putAll(hints);
        }
    }

    public Hints(RenderingHints hints) {
        this();
        if (hints != null) {
            this.putAll((Map<?, ?>)hints);
        }
    }

    @Override
    public Hints clone() {
        return (Hints)super.clone();
    }

    @Override
    public String toString() {
        return Hints.toString(this);
    }

    private static String toString(Map<?, ?> hints) {
        return Hints.format(hints);
    }

    private static String format(Map<?, ?> hints) {
        TableAppender table;
        try {
            table = new TableAppender(" ");
            Hints.format(table, hints, "  ");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return table.toString();
    }

    private static void format(TableAppender table, Map<?, ?> hints, String indent) throws IOException {
        for (Map.Entry<?, ?> entry : hints.entrySet()) {
            Object k = entry.getKey();
            String key = k instanceof RenderingHints.Key ? Hints.nameOf((RenderingHints.Key)k) : String.valueOf(k);
            Object value = entry.getValue();
            table.append((CharSequence)indent);
            table.append((CharSequence)key);
            char separator = ':';
            table.nextColumn();
            table.append(separator);
            table.append(' ');
            table.append((CharSequence)String.valueOf(value));
            table.nextLine();
        }
    }

    private static Class<?> getEnclosingClass(RenderingHints.Key key) {
        Class<Object> c = key.getClass().getEnclosingClass();
        if (c != null && c.getName().startsWith("sun.")) {
            c = RenderingHints.class;
        }
        return c;
    }

    static String nameOf(RenderingHints.Key key) {
        Field field;
        if (key == null) {
            return null;
        }
        if (!(key instanceof Key) && (field = Hints.fieldOf(key)) != null) {
            return field.getName();
        }
        return key.toString();
    }

    static Field fieldOf(RenderingHints.Key key) {
        Class<?> c;
        Field field = null;
        if (key != null && ((c = Hints.getEnclosingClass(key)) == null || (field = Hints.fieldOf(c, key)) == null) && key instanceof Key && c != (c = ((Key)key).getValueClass())) {
            field = Hints.fieldOf(c, key);
        }
        return field;
    }

    private static String nameOf(Class<?> type, RenderingHints.Key key) {
        Field f = Hints.fieldOf(type, key);
        return f != null ? f.getName() : null;
    }

    private static Field fieldOf(Class<?> type, RenderingHints.Key key) {
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object v;
            Field f = fields[i];
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                v = f.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (v != key) continue;
            return f;
        }
        return null;
    }

    public static class Key
    extends RenderingHints.Key
    implements Serializable {
        private static int count;
        private final String className;
        private transient Class<?> valueClass;

        public Key(Class<?> classe) {
            this(classe.getName());
            this.valueClass = classe;
        }

        public Key(String className) {
            super(Key.count());
            this.className = className;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class<?> getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException exception) {
                    Logging.unexpectedException(null, Key.class, (String)"getValueClass", (Throwable)exception);
                    this.valueClass = Object.class;
                }
            }
            return this.valueClass;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            return this.getValueClass().isInstance(value);
        }

        public String toString() {
            Class<?> c = Hints.getEnclosingClass(this);
            String name = Hints.nameOf(c, this);
            if (name == null) {
                if (c != (c = this.getValueClass())) {
                    name = Hints.nameOf(c, this);
                }
                if (name == null) {
                    name = super.toString();
                }
            }
            return name;
        }

        protected final Object writeReplace() throws ObjectStreamException {
            return new SerializedKey(this);
        }
    }

    public static final class ClassKey
    extends Key {
        public ClassKey(Class<?> classe) {
            super(classe);
        }

        public ClassKey(String className) {
            super(className);
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Class[]) {
                Class[] types = (Class[])value;
                for (int i = 0; i < types.length; ++i) {
                    if (this.isCompatibleValue(types[i])) continue;
                    return false;
                }
                return types.length != 0;
            }
            if (value instanceof Class) {
                int modifiers;
                Class type = (Class)value;
                Class<?> expected = this.getValueClass();
                if (expected.isAssignableFrom(type)) {
                    return true;
                }
                return expected.isInterface() && !type.isInterface() && Modifier.isAbstract(modifiers = type.getModifiers()) && !Modifier.isFinal(modifiers);
            }
            return super.isCompatibleValue(value);
        }
    }

    public static final class OptionKey
    extends Key {
        private final Set<String> options;
        private final boolean wildcard;

        public OptionKey(String ... alternatives) {
            super(String.class);
            TreeSet<String> options = new TreeSet<String>(Arrays.asList(alternatives));
            this.wildcard = options.remove("*");
            this.options = CollectionsExt.unmodifiableOrCopy(options);
        }

        public Set<String> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            return this.wildcard ? value instanceof String : this.options.contains(value);
        }
    }

    public static final class IntegerKey
    extends Key {
        private final int number;

        public IntegerKey(int number) {
            super(Integer.class);
            this.number = number;
        }

        public int getDefault() {
            return this.number;
        }

        public int toValue(Hints hints) {
            if (hints != null) {
                Object value = hints.get(this);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof CharSequence) {
                    return Integer.parseInt(value.toString());
                }
            }
            return this.number;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            if (value instanceof Short || value instanceof Integer) {
                return true;
            }
            if (value instanceof String || value instanceof InternationalString) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    Logger.getLogger("org.geotoolkit.factory").finer(e.toString());
                }
            }
            return false;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean writable) {
            super(Path.class);
            this.writable = writable;
        }

        @Override
        public boolean isCompatibleValue(Object value) {
            Path path;
            if (value instanceof Path) {
                path = (Path)value;
            } else if (value instanceof File) {
                path = ((File)value).toPath();
            } else if (value instanceof String) {
                path = Paths.get((String)value, new String[0]);
            } else {
                return false;
            }
            if (this.writable) {
                if (Files.exists(path, new LinkOption[0])) {
                    return Files.isWritable(path);
                }
                Path parent = path.getParent();
                return parent != null && Files.isWritable(parent);
            }
            return Files.isReadable(path);
        }
    }
}

