/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gui.swing.tree;

import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.geotoolkit.gui.swing.tree.TreeTableNode;
import org.geotoolkit.io.ExpandedTabWriter;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.resources.Errors;

@Deprecated
final class TreeFormat {
    private int indentation = 4;
    private int verticalLinePosition;
    private String lineSeparator;
    private char columnSeparator = (char)8230;
    private boolean isTableFormatEnabled;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private transient Writer lineWriter;
    private transient StringBuffer lineBuffer;

    public TreeFormat() {
        this.lineSeparator = System.lineSeparator();
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive((String)"indentation", (int)indentation);
        this.indentation = indentation;
        if (this.verticalLinePosition > indentation) {
            this.verticalLinePosition = indentation;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int verticalLinePosition) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween((String)"verticalLinePosition", (int)0, (int)this.indentation, (int)verticalLinePosition);
        this.verticalLinePosition = verticalLinePosition;
        this.clearTreeSymbols();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String separator) {
        ArgumentChecks.ensureNonNull((String)"separator", (Object)separator);
        this.lineSeparator = separator;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(char separator) {
        this.columnSeparator = separator;
    }

    public boolean isTableFormatEnabled() {
        return this.isTableFormatEnabled;
    }

    public void setTableFormatEnabled(boolean enabled) {
        this.isTableFormatEnabled = enabled;
    }

    private static boolean hasTreeTableNode(TreeNode node) {
        if (node instanceof TreeTableNode) {
            return true;
        }
        Enumeration<? extends TreeNode> e = node.children();
        if (e != null) {
            while (e.hasMoreElements()) {
                if (!TreeFormat.hasTreeTableNode(e.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    private void ensureInitialized() {
        if (this.treeBlank == null) {
            int indentation = this.indentation;
            int verticalLinePosition = this.verticalLinePosition;
            char[] buffer = new char[indentation];
            block6: for (int k = 0; k < 4; ++k) {
                char hc;
                int vc;
                if ((k & 2) == 0) {
                    vc = (k & 1) == 0 ? 160 : 9474;
                    hc = '\u00a0';
                } else {
                    vc = (k & 1) == 0 ? 9492 : 9500;
                    hc = '\u2500';
                }
                Arrays.fill(buffer, 0, verticalLinePosition, '\u00a0');
                buffer[verticalLinePosition] = vc;
                Arrays.fill(buffer, verticalLinePosition + 1, indentation, hc);
                String symbols = String.valueOf(buffer);
                switch (k) {
                    case 0: {
                        this.treeBlank = symbols;
                        continue block6;
                    }
                    case 1: {
                        this.treeLine = symbols;
                        continue block6;
                    }
                    case 2: {
                        this.treeEnd = symbols;
                        continue block6;
                    }
                    case 3: {
                        this.treeCross = symbols;
                        continue block6;
                    }
                    default: {
                        throw new AssertionError(k);
                    }
                }
            }
        }
    }

    private String toString(Object value) throws IOException {
        Writer writer = this.lineWriter;
        if (writer == null) {
            StringWriter buffer = new StringWriter();
            this.lineWriter = writer = new ExpandedTabWriter(new LineWriter(buffer, " \u00b6 "));
            this.lineBuffer = buffer.getBuffer();
        }
        writer.write(String.valueOf(value));
        writer.flush();
        String text = this.lineBuffer.toString();
        writer.write(10);
        this.lineBuffer.setLength(0);
        return text;
    }

    private boolean[] format(TreeModel model, Object node, Appendable toAppendTo, int level, boolean[] last) throws IOException {
        for (int i = 0; i < level; ++i) {
            boolean isLast = last[i];
            toAppendTo.append(i != level - 1 ? (isLast ? this.treeBlank : this.treeLine) : (isLast ? this.treeEnd : this.treeCross));
        }
        if (node instanceof TreeTableNode && toAppendTo instanceof TableAppender) {
            TreeTableNode tableNode = (TreeTableNode)node;
            int columnCount = tableNode.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                Object value;
                if (i != 0) {
                    ((TableAppender)toAppendTo.append(this.columnSeparator)).nextColumn(this.columnSeparator);
                }
                if ((value = tableNode.getValueAt(i)) == null) continue;
                toAppendTo.append(this.toString(value));
            }
        } else {
            toAppendTo.append(this.toString(node));
        }
        toAppendTo.append(this.lineSeparator);
        if (level >= last.length) {
            last = Arrays.copyOf(last, level * 2);
        }
        int count = model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            last[level] = i == count - 1;
            last = this.format(model, model.getChild(node, i), toAppendTo, level + 1, last);
        }
        return last;
    }

    public void format(TreeModel tree, Appendable toAppendTo) throws IOException {
        Object root = tree.getRoot();
        if (root != null) {
            StringWriter buffer = null;
            Appendable out = toAppendTo;
            if (this.isTableFormatEnabled && root instanceof TreeNode && TreeFormat.hasTreeTableNode((TreeNode)root)) {
                Writer writer;
                if (toAppendTo instanceof Writer) {
                    writer = (Writer)toAppendTo;
                } else {
                    buffer = new StringWriter();
                    writer = buffer;
                }
                out = new TableAppender((Appendable)new LineWriter(writer, this.lineSeparator), " ");
            }
            this.ensureInitialized();
            this.format(tree, root, out, 0, new boolean[64]);
            if (out != toAppendTo) {
                ((Flushable)((Object)out)).flush();
            }
            if (buffer != null) {
                toAppendTo.append(((Object)buffer).toString());
            }
        }
    }

    public final void format(TreeModel tree, StringBuilder toAppendTo) {
        try {
            this.format(tree, (Appendable)toAppendTo);
        }
        catch (IOException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    public void format(TreeNode node, Appendable toAppendTo) throws IOException {
        this.format((TreeModel)new DefaultTreeModel(node, true), toAppendTo);
    }

    public final void format(TreeNode node, StringBuilder toAppendTo) {
        try {
            this.format(node, (Appendable)toAppendTo);
        }
        catch (IOException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    public void format(Iterable<?> nodes, Appendable toAppendTo) throws IOException {
        this.ensureInitialized();
        Iterator<?> it = nodes.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            String next;
            String margin;
            CharSequence[] lines = CharSequences.splitOnEOL((CharSequence)String.valueOf(it.next()));
            hasNext = it.hasNext();
            if (hasNext) {
                margin = this.treeCross;
                next = this.treeLine;
            } else {
                margin = this.treeEnd;
                next = this.treeBlank;
            }
            for (CharSequence line : lines) {
                if (line.length() == 0) continue;
                toAppendTo.append(margin).append(line).append(this.lineSeparator);
                margin = next;
            }
        }
    }

    public final void format(Iterable<?> nodes, StringBuilder toAppendTo) {
        try {
            this.format(nodes, (Appendable)toAppendTo);
        }
        catch (IOException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    public StringBuffer format(Object tree, StringBuffer toAppendTo, FieldPosition pos) {
        block5: {
            ArgumentChecks.ensureNonNull((String)"tree", (Object)tree);
            try {
                if (tree instanceof TreeModel) {
                    this.format((TreeModel)tree, (Appendable)toAppendTo);
                    break block5;
                }
                if (tree instanceof TreeNode) {
                    this.format((TreeNode)tree, (Appendable)toAppendTo);
                    break block5;
                }
                if (tree instanceof Iterable) {
                    this.format((Iterable)tree, (Appendable)toAppendTo);
                    break block5;
                }
                throw new IllegalArgumentException(Errors.format((short)51, "tree", tree.getClass(), TreeModel.class));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return toAppendTo;
    }
}

