/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.Deprecable;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

final class IdentifierCode
extends ImmutableIdentifier
implements Deprecable {
    private static final long serialVersionUID = 357222258307746767L;
    final int supersededBy;

    IdentifierCode(Citation authority, int code) {
        this(authority, code, 0);
    }

    IdentifierCode(Citation authority, int code, int supersededBy) {
        super(authority, IdentifierCode.codespace(authority), Integer.toString(code), null, IdentifierCode.remarks(supersededBy));
        this.supersededBy = supersededBy;
    }

    private static String codespace(Citation authority) {
        String t;
        if (authority != null && (t = Citations.toCodeSpace((Citation)authority)) != null) {
            return t.substring(t.lastIndexOf(58) + 1).trim();
        }
        return null;
    }

    private static InternationalString remarks(int supersededBy) {
        if (supersededBy == 0) {
            return null;
        }
        return Vocabulary.formatInternational((short)255, (Object)supersededBy);
    }

    public boolean isDeprecated() {
        return this.supersededBy != 0;
    }

    public InternationalString getRemarks() {
        return super.getDescription();
    }
}

