/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.CharSequenceAdapter;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.xml.MarshalContext;

public class URIAdapter
extends XmlAdapter<GO_CharacterString, URI> {
    public final URI unmarshal(GO_CharacterString value) throws URISyntaxException {
        String text = StringAdapter.toString(value);
        if (text != null) {
            Context context = Context.current();
            return Context.converter(context).toURI((MarshalContext)context, text);
        }
        return null;
    }

    public GO_CharacterString marshal(URI value) {
        Context context;
        GO_CharacterString wrapper;
        if (value != null && (wrapper = CharSequenceAdapter.wrap(context = Context.current(), value, value.toString())) != null && wrapper.type == 0) {
            if (!Context.isFlagSet(context, 8)) {
                wrapper.type = (byte)3;
            }
            return wrapper;
        }
        return null;
    }

    public static final class AsURL
    extends URIAdapter {
        @Override
        public GO_CharacterString marshal(URI value) {
            GO_CharacterString wrapper = super.marshal(value);
            if (wrapper != null && wrapper.type == 3 && !FilterByVersion.CURRENT_METADATA.accept()) {
                wrapper.type = (byte)2;
            }
            return wrapper;
        }
    }
}

