/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gcx;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.xml.XLink;
import org.opengis.util.InternationalString;

@XmlType(name="Anchor_Type")
@XmlRootElement(name="Anchor")
public final class Anchor
extends XLink
implements InternationalString {
    private static final long serialVersionUID = -7896134857052775101L;
    @XmlValue
    private String value;

    public Anchor() {
    }

    public Anchor(XLink xlink, String value) {
        super(xlink);
        this.value = value;
    }

    public Anchor(URI href, String value) {
        this.setHRef(href);
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String toString(Locale locale) {
        return this.value;
    }

    public int length() {
        return this.value != null ? this.value.length() : 0;
    }

    public char charAt(int index) {
        return (this.value != null ? this.value : "").charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        String substring;
        String original = this.value;
        if (original == null) {
            original = "";
        }
        if ((substring = original.substring(start, end)) == original) {
            return this;
        }
        return new Anchor(this, substring);
    }

    public int compareTo(InternationalString other) {
        String ot;
        if (other == null || (ot = other.toString()) == null) {
            return this.value != null ? -1 : 0;
        }
        return this.value != null ? this.value.compareTo(ot) : 1;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Anchor that = (Anchor)object;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Objects.hashCode(this.value);
    }
}

