/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.legacy;

import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.util.CodeLists;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@UML(identifier="MD_MediumNameCode", specification=Specification.ISO_19115, version=2003)
public final class MediumName
extends CodeList<MediumName>
implements Citation {
    private static final long serialVersionUID = 7157038832444373933L;
    private static final List<MediumName> VALUES = new ArrayList<MediumName>(18);
    @UML(identifier="cdRom", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CD_ROM = new MediumName("CD_ROM");
    @UML(identifier="dvd", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName DVD = new MediumName("DVD");
    @UML(identifier="dvdRom", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName DVD_ROM = new MediumName("DVD_ROM");
    @UML(identifier="3halfInchFloppy", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName FLOPPY_3_HALF_INCH = new MediumName("FLOPPY_3_HALF_INCH");
    @UML(identifier="5quarterInchFloppy", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName FLOPPY_5_QUARTER_INCH = new MediumName("FLOPPY_5_QUARTER_INCH");
    @UML(identifier="7trackTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName TAPE_7_TRACK = new MediumName("TAPE_7_TRACK");
    @UML(identifier="9trackTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName TAPE_9_TRACK = new MediumName("TAPE_9_TRACK");
    @UML(identifier="3480Cartridge", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_3480 = new MediumName("CARTRIDGE_3480");
    @UML(identifier="3490Cartridge", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_3490 = new MediumName("CARTRIDGE_3490");
    @UML(identifier="3580Cartridge", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_3580 = new MediumName("CARTRIDGE_3580");
    @UML(identifier="4mmCartridgeTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_TAPE_4mm = new MediumName("CARTRIDGE_TAPE_4mm");
    @UML(identifier="8mmCartridgeTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_TAPE_8mm = new MediumName("CARTRIDGE_TAPE_8mm");
    @UML(identifier="1quarterInchCartridgeTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName CARTRIDGE_TAPE_1_QUARTER_INCH = new MediumName("CARTRIDGE_TAPE_1_QUARTER_INCH");
    @UML(identifier="digitalLinearTape", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName DIGITAL_LINEAR_TAPE = new MediumName("DIGITAL_LINEAR_TAPE");
    @UML(identifier="onLine", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName ON_LINE = new MediumName("ON_LINE");
    @UML(identifier="satellite", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName SATELLITE = new MediumName("SATELLITE");
    @UML(identifier="telephoneLink", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName TELEPHONE_LINK = new MediumName("TELEPHONE_LINK");
    @UML(identifier="hardcopy", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final MediumName HARDCOPY = new MediumName("HARDCOPY");

    private MediumName(String name) {
        super(name, VALUES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediumName[] values() {
        List<MediumName> list = VALUES;
        synchronized (list) {
            return (MediumName[])VALUES.toArray(MediumName[]::new);
        }
    }

    public MediumName[] family() {
        return MediumName.values();
    }

    public static MediumName valueOf(String code) {
        return CodeLists.forName(MediumName.class, code, false);
    }

    public static MediumName castOrWrap(Citation citation) {
        InternationalString title;
        if (citation instanceof MediumName) {
            return (MediumName)citation;
        }
        if (citation != null && (title = citation.getTitle()) != null) {
            return MediumName.valueOf(title.toString());
        }
        return null;
    }

    public InternationalString getTitle() {
        return Types.toInternationalString(this.name());
    }
}

