/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultAggregateInformation;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultServiceIdentification;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.AssociatedResource;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.temporal.Duration;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractMD_Identification_Type", propOrder={"citation", "abstract", "purpose", "credits", "status", "pointOfContacts", "spatialRepresentationTypes", "spatialResolutions", "temporalResolution", "topicCategories", "extents", "additionalDocumentation", "processingLevel", "resourceMaintenances", "graphicOverviews", "resourceFormats", "descriptiveKeywords", "resourceSpecificUsages", "resourceConstraints", "associatedResource", "aggregationInfo"})
@XmlRootElement(name="AbstractMD_Identification")
@XmlSeeAlso(value={DefaultDataIdentification.class, DefaultServiceIdentification.class})
public class AbstractIdentification
extends ISOMetadata
implements Identification {
    private static final long serialVersionUID = -1132210324047663554L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection<InternationalString> credits;
    private Collection<Progress> status;
    private Collection<Responsibility> pointOfContacts;
    private Collection<SpatialRepresentationType> spatialRepresentationTypes;
    private Collection<Resolution> spatialResolutions;
    private Collection<Duration> temporalResolutions;
    private Collection<TopicCategory> topicCategories;
    private Collection<Extent> extents;
    private Collection<Citation> additionalDocumentations;
    private Identifier processingLevel;
    private Collection<MaintenanceInformation> resourceMaintenances;
    private Collection<BrowseGraphic> graphicOverviews;
    private Collection<Format> resourceFormats;
    private Collection<Keywords> descriptiveKeywords;
    private Collection<Usage> resourceSpecificUsages;
    private Collection<Constraints> resourceConstraints;
    private Collection<AssociatedResource> associatedResources;

    public AbstractIdentification() {
    }

    public AbstractIdentification(Citation citation, CharSequence abstracts) {
        this.citation = citation;
        this.abstracts = Types.toInternationalString(abstracts);
    }

    public AbstractIdentification(Identification object) {
        super(object);
        if (object != null) {
            this.citation = object.getCitation();
            this.abstracts = object.getAbstract();
            this.purpose = object.getPurpose();
            this.credits = this.copyCollection(object.getCredits(), InternationalString.class);
            this.status = this.copyCollection(object.getStatus(), Progress.class);
            this.pointOfContacts = this.copyCollection(object.getPointOfContacts(), Responsibility.class);
            this.spatialRepresentationTypes = this.copyCollection(object.getSpatialRepresentationTypes(), SpatialRepresentationType.class);
            this.spatialResolutions = this.copyCollection(object.getSpatialResolutions(), Resolution.class);
            this.temporalResolutions = this.copyCollection(object.getTemporalResolutions(), Duration.class);
            this.topicCategories = this.copyCollection(object.getTopicCategories(), TopicCategory.class);
            this.extents = this.copyCollection(object.getExtents(), Extent.class);
            this.additionalDocumentations = this.copyCollection(object.getAdditionalDocumentations(), Citation.class);
            this.processingLevel = object.getProcessingLevel();
            this.resourceMaintenances = this.copyCollection(object.getResourceMaintenances(), MaintenanceInformation.class);
            this.graphicOverviews = this.copyCollection(object.getGraphicOverviews(), BrowseGraphic.class);
            this.resourceFormats = this.copyCollection(object.getResourceFormats(), Format.class);
            this.descriptiveKeywords = this.copyCollection(object.getDescriptiveKeywords(), Keywords.class);
            this.resourceSpecificUsages = this.copyCollection(object.getResourceSpecificUsages(), Usage.class);
            this.resourceConstraints = this.copyCollection(object.getResourceConstraints(), Constraints.class);
            this.associatedResources = this.copyCollection(object.getAssociatedResources(), AssociatedResource.class);
        }
    }

    public static AbstractIdentification castOrCopy(Identification object) {
        if (object instanceof DataIdentification) {
            return DefaultDataIdentification.castOrCopy((DataIdentification)object);
        }
        if (object instanceof ServiceIdentification) {
            return DefaultServiceIdentification.castOrCopy((ServiceIdentification)object);
        }
        if (object == null || object instanceof AbstractIdentification) {
            return (AbstractIdentification)object;
        }
        return new AbstractIdentification(object);
    }

    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission(this.citation);
        this.citation = newValue;
    }

    @XmlElement(name="abstract", required=true)
    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public void setAbstract(InternationalString newValue) {
        this.checkWritePermission(this.abstracts);
        this.abstracts = newValue;
    }

    @XmlElement(name="purpose")
    public InternationalString getPurpose() {
        return this.purpose;
    }

    public void setPurpose(InternationalString newValue) {
        this.checkWritePermission(this.purpose);
        this.purpose = newValue;
    }

    @XmlElement(name="credit")
    public Collection<InternationalString> getCredits() {
        this.credits = this.nonNullCollection(this.credits, InternationalString.class);
        return this.credits;
    }

    public void setCredits(Collection<? extends InternationalString> newValues) {
        this.credits = this.writeCollection(newValues, this.credits, InternationalString.class);
    }

    @XmlElement(name="status")
    public Collection<Progress> getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public void setStatus(Collection<? extends Progress> newValues) {
        this.status = this.writeCollection(newValues, this.status, Progress.class);
    }

    @XmlElement(name="pointOfContact")
    public Collection<Responsibility> getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, Responsibility.class);
        return this.pointOfContacts;
    }

    public void setPointOfContacts(Collection<? extends Responsibility> newValues) {
        this.pointOfContacts = this.writeCollection(newValues, this.pointOfContacts, Responsibility.class);
    }

    @XmlElement(name="spatialRepresentationType")
    public Collection<SpatialRepresentationType> getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public void setSpatialRepresentationTypes(Collection<? extends SpatialRepresentationType> newValues) {
        this.spatialRepresentationTypes = this.writeCollection(newValues, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    @XmlElement(name="spatialResolution")
    public Collection<Resolution> getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public void setSpatialResolutions(Collection<? extends Resolution> newValues) {
        this.spatialResolutions = this.writeCollection(newValues, this.spatialResolutions, Resolution.class);
    }

    public Collection<Duration> getTemporalResolutions() {
        this.temporalResolutions = this.nonNullCollection(this.temporalResolutions, Duration.class);
        return this.temporalResolutions;
    }

    public void setTemporalResolutions(Collection<? extends Duration> newValues) {
        this.temporalResolutions = this.writeCollection(newValues, this.temporalResolutions, Duration.class);
    }

    @XmlElement(name="topicCategory")
    public Collection<TopicCategory> getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public void setTopicCategories(Collection<? extends TopicCategory> newValues) {
        this.topicCategories = this.writeCollection(newValues, this.topicCategories, TopicCategory.class);
    }

    @XmlElement(name="extent")
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    public Collection<Citation> getAdditionalDocumentations() {
        this.additionalDocumentations = this.nonNullCollection(this.additionalDocumentations, Citation.class);
        return this.additionalDocumentations;
    }

    public void setAdditionalDocumentations(Collection<? extends Citation> newValues) {
        this.additionalDocumentations = this.writeCollection(newValues, this.additionalDocumentations, Citation.class);
    }

    @XmlElement(name="processingLevel")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    public Identifier getProcessingLevel() {
        return this.processingLevel;
    }

    public void setProcessingLevel(Identifier newValue) {
        this.checkWritePermission(this.processingLevel);
        this.processingLevel = newValue;
    }

    @XmlElement(name="resourceMaintenance")
    public Collection<MaintenanceInformation> getResourceMaintenances() {
        this.resourceMaintenances = this.nonNullCollection(this.resourceMaintenances, MaintenanceInformation.class);
        return this.resourceMaintenances;
    }

    public void setResourceMaintenances(Collection<? extends MaintenanceInformation> newValues) {
        this.resourceMaintenances = this.writeCollection(newValues, this.resourceMaintenances, MaintenanceInformation.class);
    }

    @XmlElement(name="graphicOverview")
    public Collection<BrowseGraphic> getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public void setGraphicOverviews(Collection<? extends BrowseGraphic> newValues) {
        this.graphicOverviews = this.writeCollection(newValues, this.graphicOverviews, BrowseGraphic.class);
    }

    @XmlElement(name="resourceFormat")
    public Collection<Format> getResourceFormats() {
        this.resourceFormats = this.nonNullCollection(this.resourceFormats, Format.class);
        return this.resourceFormats;
    }

    public void setResourceFormats(Collection<? extends Format> newValues) {
        this.resourceFormats = this.writeCollection(newValues, this.resourceFormats, Format.class);
    }

    @XmlElement(name="descriptiveKeywords")
    public Collection<Keywords> getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public void setDescriptiveKeywords(Collection<? extends Keywords> newValues) {
        this.descriptiveKeywords = this.writeCollection(newValues, this.descriptiveKeywords, Keywords.class);
    }

    @XmlElement(name="resourceSpecificUsage")
    public Collection<Usage> getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public void setResourceSpecificUsages(Collection<? extends Usage> newValues) {
        this.resourceSpecificUsages = this.writeCollection(newValues, this.resourceSpecificUsages, Usage.class);
    }

    @XmlElement(name="resourceConstraints")
    public Collection<Constraints> getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public void setResourceConstraints(Collection<? extends Constraints> newValues) {
        this.resourceConstraints = this.writeCollection(newValues, this.resourceConstraints, Constraints.class);
    }

    public Collection<AssociatedResource> getAssociatedResources() {
        this.associatedResources = this.nonNullCollection(this.associatedResources, AssociatedResource.class);
        return this.associatedResources;
    }

    public void setAssociatedResources(Collection<? extends AssociatedResource> newValues) {
        this.associatedResources = this.writeCollection(newValues, this.associatedResources, AssociatedResource.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getAssociatedResources"})
    @XmlElement(name="aggregationInfo", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<AggregateInformation> getAggregationInfo() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<AggregateInformation, AssociatedResource>(this.getAssociatedResources()){

            @Override
            protected AssociatedResource wrap(AggregateInformation value) {
                return value;
            }

            @Override
            protected AggregateInformation unwrap(AssociatedResource container) {
                return DefaultAggregateInformation.castOrCopy(container);
            }

            @Override
            protected boolean update(AssociatedResource container, AggregateInformation value) {
                return container == value;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setAggregationInfo(Collection<? extends AggregateInformation> newValues) {
        this.setAssociatedResources(newValues);
    }

    @XmlElement(name="temporalResolution")
    private Collection<Duration> getTemporalResolution() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getTemporalResolutions() : null;
    }

    @XmlElement(name="additionalDocumentation")
    private Collection<Citation> getAdditionalDocumentation() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAdditionalDocumentations() : null;
    }

    @XmlElement(name="associatedResource")
    private Collection<AssociatedResource> getAssociatedResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAssociatedResources() : null;
    }
}

