/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;

public final class FinalFieldSetter {
    private FinalFieldSetter() {
    }

    public static <T> void set(Class<T> classe, String field, T instance, Object value) throws NoSuchFieldException, IllegalAccessException {
        assert (classe.getName().startsWith("org.apache.sis.")) : classe;
        Field f = classe.getDeclaredField(field);
        f.setAccessible(true);
        f.set(instance, value);
    }

    public static <T> void set(Class<T> classe, String field, String second, T instance, Object value, Object more) throws NoSuchFieldException, IllegalAccessException {
        FinalFieldSetter.set(classe, field, instance, value);
        Field f = classe.getDeclaredField(second);
        f.setAccessible(true);
        f.set(instance, more);
    }

    public static InvalidClassException readFailure(ReflectiveOperationException cause) {
        return (InvalidClassException)new InvalidClassException(cause.getLocalizedMessage()).initCause(cause);
    }

    public static RuntimeException cloneFailure(ReflectiveOperationException cause) {
        return (InaccessibleObjectException)new InaccessibleObjectException().initCause(cause);
    }
}

