/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.util.AutoMessageFormat;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.IO;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;

public class MonolineFormatter
extends Formatter {
    private static final int NO_SOURCE = 0;
    private static final int LOGGER_SHORT = 1;
    private static final int LOGGER_LONG = 2;
    private static final int CLASS_SHORT = 3;
    private static final int CLASS_LONG = 4;
    private static final int METHOD = 5;
    private static final String[] FORMAT_LABELS = new String[6];
    private static final Level LEVEL_THRESHOLD;
    private static final Comparator<Level> COMPARATOR;
    private static final boolean SHOW_LEVEL = true;
    private static final int CONTINUATION_MARGIN = 4;
    private static final int CONTEXT_STACK_TRACE_ELEMENTS = 2;
    private static final int MAX_CAUSES = 10;
    private String header = "";
    private SortedMap<Level, X364> colors;
    private final boolean faintSupported;
    private transient int[] colorLevels;
    private transient String[] colorSequences;
    private final int levelWidth;
    private final long startMillis = System.currentTimeMillis();
    private SimpleDateFormat timeFormat;
    private transient AutoMessageFormat messageFormat;
    private transient String messagePattern;
    private int sourceFormat = 0;
    private final StringBuffer buffer;
    private final LineAppender writer;
    private final PrintWriter printer;

    public MonolineFormatter() {
        this(null);
    }

    public MonolineFormatter(Handler handler) {
        this.levelWidth = MonolineFormatter.levelWidth(handler != null ? handler.getLevel() : null);
        LogManager manager = LogManager.getLogManager();
        String classname = MonolineFormatter.class.getName();
        this.header = manager.getProperty(classname + ".header");
        if (this.header == null) {
            this.header = "";
        }
        try {
            this.timeFormat(manager.getProperty(classname + ".time"));
        }
        catch (IllegalArgumentException exception) {
            Logging.configurationException(Logger.getLogger("org.apache.sis.util"), MonolineFormatter.class, "<init>", exception);
        }
        try {
            this.sourceFormat(manager.getProperty(classname + ".source"));
        }
        catch (IllegalArgumentException exception) {
            Logging.configurationException(Logger.getLogger("org.apache.sis.util"), MonolineFormatter.class, "<init>", exception);
        }
        if (handler instanceof ConsoleHandler && X364.isAnsiSupported()) {
            this.resetLevelColors();
        }
        this.faintSupported = System.getProperty("os.name", "").contains("Mac OS");
        StringWriter str = new StringWriter();
        this.writer = new LineAppender((Appendable)str, System.lineSeparator(), true);
        this.buffer = str.getBuffer().append(this.header);
        this.printer = new PrintWriter(IO.asWriter(this.writer));
        this.writer.setTabulationWidth(4);
    }

    static int levelWidth(Level threshold) {
        int levelWidth = 0;
        int i = 0;
        block9: while (true) {
            Level c;
            switch (i) {
                case 0: {
                    c = Level.SEVERE;
                    break;
                }
                case 1: {
                    c = Level.WARNING;
                    break;
                }
                case 2: {
                    c = Level.INFO;
                    break;
                }
                case 3: {
                    c = Level.CONFIG;
                    break;
                }
                case 4: {
                    c = Level.FINE;
                    break;
                }
                case 5: {
                    c = Level.FINER;
                    break;
                }
                case 6: {
                    c = Level.FINEST;
                    break;
                }
                default: {
                    break block9;
                }
            }
            if (threshold != null && c.intValue() < threshold.intValue()) break;
            int length = c.getLocalizedName().length();
            if (length > levelWidth) {
                levelWidth = length;
            }
            ++i;
        }
        return levelWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader() {
        String header;
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            header = this.header;
        }
        return header.isEmpty() ? null : header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String header) {
        if (header == null) {
            header = "";
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.header = header;
            this.buffer.setLength(0);
            this.buffer.append(header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeFormat() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            return this.timeFormat != null ? this.timeFormat.toPattern() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeFormat(String pattern) throws IllegalArgumentException {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.timeFormat(pattern);
        }
    }

    private void timeFormat(String pattern) throws IllegalArgumentException {
        if (pattern == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(pattern);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceFormat() {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            return FORMAT_LABELS[this.sourceFormat];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFormat(String format) throws IllegalArgumentException {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.sourceFormat(format);
        }
    }

    private void sourceFormat(String format) throws IllegalArgumentException {
        if (format == null) {
            this.sourceFormat = 0;
            return;
        }
        format = format.strip().toLowerCase(Locale.US);
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!format.equals(FORMAT_LABELS[i])) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLevelColor(Level level) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            X364 code;
            if (this.colors != null && (code = (X364)((Object)this.colors.get(level))) != null) {
                return code.color;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelColor(Level level, String color) throws IllegalArgumentException {
        boolean changed = false;
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (color != null) {
                X364 code = X364.forColorName(color).background();
                changed = this.colors().put(level, code) != code;
            } else if (this.colors != null) {
                boolean bl = changed = this.colors.remove(level) != null;
                if (this.colors.isEmpty()) {
                    this.colors = null;
                }
            }
            if (changed) {
                this.colorLevels = null;
                this.colorSequences = null;
            }
        }
    }

    private SortedMap<Level, X364> colors() {
        if (this.colors == null) {
            this.colors = new TreeMap<Level, X364>(COMPARATOR);
        }
        return this.colors;
    }

    private void resetLevelColors() {
        SortedMap<Level, X364> colors = this.colors();
        colors.clear();
        colors.put(Level.ALL, X364.BACKGROUND_GRAY);
        colors.put(Level.CONFIG, X364.BACKGROUND_BLUE);
        colors.put(Level.INFO, X364.BACKGROUND_GREEN);
        colors.put(Level.WARNING, X364.BACKGROUND_YELLOW);
        colors.put(Level.SEVERE, X364.BACKGROUND_RED);
        colors.put(PerformanceLevel.SLOWNESS, X364.BACKGROUND_CYAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLevelColors(boolean enabled) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (enabled) {
                this.resetLevelColors();
            } else {
                this.colors = null;
                this.colorLevels = null;
                this.colorSequences = null;
            }
        }
    }

    private String colorAt(Level level) {
        int i;
        if (this.colorSequences == null) {
            this.colorSequences = new String[this.colors.size()];
            this.colorLevels = new int[this.colorSequences.length];
            i = 0;
            for (Map.Entry<Level, X364> entry : this.colors.entrySet()) {
                this.colorSequences[i] = entry.getValue().background().sequence();
                this.colorLevels[i++] = entry.getKey().intValue();
            }
        }
        if ((i = Arrays.binarySearch(this.colorLevels, level.intValue())) < 0) {
            i = Math.max(~i - 1, 0);
        }
        return this.colorSequences[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        StringBuffer buffer;
        boolean faint = false;
        String emphasisStart = "";
        String emphasisEnd = "";
        Level level = record.getLevel();
        StringBuffer stringBuffer = buffer = this.buffer;
        synchronized (stringBuffer) {
            Object source;
            boolean colors;
            boolean bl = colors = this.colors != null;
            if (colors && level.intValue() >= LEVEL_THRESHOLD.intValue()) {
                emphasisStart = X364.BOLD.sequence();
                emphasisEnd = X364.NORMAL.sequence();
                faint = this.faintSupported;
            }
            buffer.setLength(this.header.length());
            if (this.timeFormat != null) {
                Date time = new Date(Math.max(0L, record.getMillis() - this.startMillis));
                this.timeFormat.format(time, buffer, new FieldPosition(0));
                buffer.append(' ');
            }
            int margin = buffer.length();
            String levelColor = "";
            String levelReset = "";
            if (colors) {
                levelColor = this.colorAt(level);
                levelReset = X364.BACKGROUND_DEFAULT.sequence();
            }
            int offset = buffer.append(levelColor).append(emphasisStart).length();
            int length = buffer.append(level.getLocalizedName()).length() - offset;
            buffer.append(emphasisEnd).append(CharSequences.spaces(this.levelWidth - length));
            margin += buffer.length() - emphasisEnd.length() - offset;
            buffer.append(levelReset).append(' ');
            switch (this.sourceFormat) {
                case 1: 
                case 2: {
                    source = record.getLoggerName();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    source = record.getSourceClassName();
                    break;
                }
                default: {
                    source = null;
                }
            }
            if (source != null) {
                switch (this.sourceFormat) {
                    case 1: 
                    case 3: 
                    case 5: {
                        source = ((String)source).substring(((String)source).lastIndexOf(46) + 1);
                    }
                }
                if (this.sourceFormat == 5) {
                    source = (String)source + "." + record.getSourceMethodName();
                }
                buffer.append(emphasisStart).append('[').append((String)source).append(']').append(emphasisEnd).append(' ');
            }
            Object bodyLineSeparator = this.writer.getLineSeparator();
            String lineSeparator = System.lineSeparator();
            if (((String)bodyLineSeparator).length() != lineSeparator.length() + margin + 1) {
                int highlight = Math.min(4, margin);
                bodyLineSeparator = lineSeparator + levelColor + "\u2503" + String.valueOf(CharSequences.spaces(highlight - 1)) + levelReset + String.valueOf(CharSequences.spaces(margin - highlight + 1));
                this.writer.setLineSeparator((String)bodyLineSeparator);
            }
            if (faint) {
                buffer.append(X364.FAINT.sequence());
            }
            Throwable exception = record.getThrown();
            String message = this.formatMessage(record);
            int length2 = 0;
            if (message != null) {
                length2 = CharSequences.skipTrailingWhitespaces(message, 0, message.length());
            }
            try {
                if (message != null) {
                    this.writer.append(message, 0, length2);
                }
                if (exception != null) {
                    if (message != null) {
                        this.writer.append("\nCaused by: ");
                    }
                    if (level.intValue() >= LEVEL_THRESHOLD.intValue()) {
                        exception.printStackTrace(this.printer);
                    } else {
                        MonolineFormatter.printAbridged(exception, this.writer, record.getLoggerName(), record.getSourceClassName(), record.getSourceMethodName());
                    }
                }
                this.writer.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            int lastMargin = buffer.length();
            do {
                length2 = CharSequences.skipTrailingWhitespaces(buffer, 0, lastMargin);
                lastMargin = buffer.lastIndexOf((String)bodyLineSeparator);
                buffer.setLength(length2);
            } while ((length2 -= lastMargin) > 0 && length2 <= ((String)bodyLineSeparator).length());
            if (faint) {
                buffer.append(X364.NORMAL.sequence());
            }
            if ((lastMargin = CharSequences.indexOf((CharSequence)buffer, 9475, lastMargin + lineSeparator.length(), lastMargin + ((String)bodyLineSeparator).length())) >= 0) {
                buffer.setCharAt(lastMargin, '\u2579');
            }
            return buffer.append(lineSeparator).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatMessage(LogRecord record) {
        char c;
        int i;
        Object[] parameters;
        String message = record.getMessage();
        ResourceBundle resources = record.getResourceBundle();
        if (resources != null) {
            message = resources.getString(message);
        }
        if ((parameters = record.getParameters()) != null && parameters.length != 0 && (i = message.indexOf(123)) >= 0 && ++i < message.length() && (c = message.charAt(i)) >= '0' && c <= '9') {
            StringBuffer stringBuffer = this.buffer;
            synchronized (stringBuffer) {
                if (this.messageFormat == null) {
                    this.messageFormat = new AutoMessageFormat(message);
                } else if (!message.equals(this.messagePattern)) {
                    this.messageFormat.applyPattern(message);
                }
                this.messagePattern = message;
                int base = this.buffer.length();
                try {
                    this.messageFormat.configure(parameters);
                    message = this.messageFormat.format(parameters, this.buffer, new FieldPosition(0)).substring(base);
                }
                finally {
                    this.buffer.setLength(base);
                }
            }
        }
        return message;
    }

    private static void printAbridged(Throwable exception, Appendable writer, String loggerName, String sourceClassName, String sourceMethodName) throws IOException {
        StackTraceElement previous = null;
        for (int numCauses = 0; numCauses < 10; ++numCauses) {
            int stopIndex;
            StackTraceElement element;
            StackTraceElement[] trace = exception.getStackTrace();
            int logProducer = trace.length;
            boolean useLoggerName = loggerName != null;
            boolean useClassName = true;
            for (int i = 0; i < trace.length; ++i) {
                element = trace[i];
                String classname = element.getClassName();
                if (classname == null) continue;
                if (useLoggerName && classname.startsWith(loggerName)) {
                    logProducer = i;
                    useLoggerName = false;
                }
                if (!classname.contains(sourceClassName)) continue;
                String m = element.getMethodName();
                if (m != null && m.equals(sourceMethodName)) {
                    logProducer = i;
                    break;
                }
                if (useClassName) {
                    logProducer = i;
                    useClassName = false;
                }
                useLoggerName = false;
            }
            if (logProducer < (stopIndex = trace.length)) {
                element = trace[logProducer];
                if (element.equals(previous)) {
                    stopIndex = 2;
                }
                previous = element;
            }
            stopIndex = Math.min(logProducer + 3, stopIndex);
            writer.append(String.valueOf(exception)).append('\n');
            for (int i = 0; i < stopIndex; ++i) {
                int numToSkip;
                if (i == 2 && (numToSkip = logProducer - 4) > 1) {
                    MonolineFormatter.more(writer, numToSkip, true);
                    i += numToSkip;
                }
                if (i == logProducer) {
                    writer.append("  \u2192");
                }
                writer.append("\tat ").append(String.valueOf(trace[i])).append('\n');
            }
            MonolineFormatter.more(writer, trace.length - stopIndex, false);
            exception = exception.getCause();
            if (exception == null) break;
            writer.append("Caused by: ");
        }
    }

    private static void more(Appendable writer, int numToSkip, boolean con) throws IOException {
        if (numToSkip > 0) {
            writer.append("... ").append(String.valueOf(numToSkip)).append(" more");
            if (con) {
                writer.append(" ...");
            }
            writer.append('\n');
        }
    }

    public static MonolineFormatter install() throws SecurityException {
        return MonolineFormatter.install(Logger.getLogger(""), null);
    }

    public static MonolineFormatter install(Logger logger, Level level) throws SecurityException {
        ArgumentChecks.ensureNonNull("logger", logger);
        MonolineFormatter monoline = null;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            Formatter formatter = handler.getFormatter();
            if (formatter instanceof MonolineFormatter) {
                monoline = (MonolineFormatter)formatter;
            } else {
                monoline = new MonolineFormatter(handler);
                handler.setFormatter(monoline);
            }
            if (level == null) break;
            handler.setLevel(level);
            break;
        }
        if (monoline == null) {
            logger.setUseParentHandlers(false);
            Logger parent = logger;
            while (parent.getUseParentHandlers() && (parent = parent.getParent()) != null) {
                for (Handler handler : parent.getHandlers()) {
                    if (handler instanceof ConsoleHandler) continue;
                    logger.addHandler(handler);
                }
            }
            ConsoleHandler handler = new ConsoleHandler();
            if (level != null) {
                handler.setLevel(level);
            }
            monoline = new MonolineFormatter(handler);
            handler.setFormatter(monoline);
            logger.addHandler(handler);
        }
        return monoline;
    }

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[3] = "class:short";
        MonolineFormatter.FORMAT_LABELS[4] = "class:long";
        MonolineFormatter.FORMAT_LABELS[5] = "class.method";
        LEVEL_THRESHOLD = Level.INFO;
        COMPARATOR = (l1, l2) -> {
            int i2;
            int i1 = l1.intValue();
            if (i1 < (i2 = l2.intValue())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        };
    }
}

