/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.FactoryException;

final class DimensionReducer {
    private int[] dimensions;
    private CoordinateReferenceSystem reducedCRS;

    DimensionReducer(GridGeometry base, CoordinateReferenceSystem targetCRS) throws FactoryException {
        CoordinateReferenceSystem sourceCRS;
        if (base != null && base.envelope != null && (sourceCRS = base.envelope.getCoordinateReferenceSystem()) != null) {
            CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
            CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
            if (sourceCS.getDimension() < targetCS.getDimension()) {
                this.dimensions = AxisDirections.indicesOfLenientMapping((CoordinateSystem)targetCS, (CoordinateSystem)sourceCS);
                if (this.dimensions != null) {
                    Arrays.sort(this.dimensions);
                    this.reducedCRS = CRS.selectDimensions((CoordinateReferenceSystem)targetCRS, (int[])this.dimensions);
                }
            }
        }
    }

    final DirectPosition apply(DirectPosition target) {
        if (this.dimensions == null) {
            return target;
        }
        GeneralDirectPosition position = new GeneralDirectPosition(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            position.coordinates[i] = target.getOrdinate(this.dimensions[i]);
        }
        return position;
    }

    final Envelope apply(Envelope target) {
        if (this.dimensions == null) {
            return target;
        }
        DirectPosition lowerCorner = target.getLowerCorner();
        DirectPosition upperCorner = target.getUpperCorner();
        GeneralEnvelope envelope = new GeneralEnvelope(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            int s = this.dimensions[i];
            envelope.setRange(i, lowerCorner.getOrdinate(s), upperCorner.getOrdinate(s));
        }
        return envelope;
    }
}

