/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.coverage.grid.ReducedGridCoverage;
import org.apache.sis.coverage.grid.SliceGeometry;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public class DimensionalityReduction
implements UnaryOperator<GridCoverage>,
Serializable {
    private static final long serialVersionUID = -6462887684250336261L;
    private final GridGeometry sourceGeometry;
    private final GridGeometry reducedGeometry;
    private final int[] gridAxesToPass;
    private final int[] crsAxesToRemove;
    private final Object[] componentsOfCRS;
    private final MathTransform removedGridToCRS;
    private final MathTransform removedCornerToCRS;
    private final Map<Integer, Long> sliceCoordinates;
    private static final int[][] CACHED = new int[16][];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] toArray(BitSet axes) {
        if (axes.length() >= CACHED.length) {
            return axes.stream().toArray();
        }
        int bitmask = (int)axes.toLongArray()[0];
        int[][] nArray = CACHED;
        synchronized (CACHED) {
            int[] indices = CACHED[bitmask];
            if (indices == null) {
                indices = axes.stream().toArray();
                DimensionalityReduction.CACHED[bitmask] = indices;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return indices;
        }
    }

    protected DimensionalityReduction(GridGeometry source, BitSet gridAxes, MathTransformFactory factory) throws FactoryException {
        this.gridAxesToPass = DimensionalityReduction.toArray(gridAxes);
        this.sliceCoordinates = Map.of();
        this.sourceGeometry = source;
        int sourceDim = source.getDimension();
        gridAxes.flip(0, sourceDim);
        if (gridAxes.isEmpty()) {
            this.reducedGeometry = source;
            this.crsAxesToRemove = ArraysExt.EMPTY_INT;
            this.componentsOfCRS = null;
        } else {
            int targetDim = source.getTargetDimension();
            int dimSubCRS = targetDim - (sourceDim - this.gridAxesToPass.length);
            SliceGeometry helper = new SliceGeometry(source, null, this.gridAxesToPass, factory);
            this.reducedGeometry = helper.reduce(null, dimSubCRS);
            BitSet crsAxes = DimensionalityReduction.bitmask(helper.getTargetDimensions(), targetDim);
            crsAxes.flip(0, targetDim);
            this.crsAxesToRemove = DimensionalityReduction.toArray(crsAxes);
            this.componentsOfCRS = source.isDefined(1) ? DimensionalityReduction.filterCRS(source.getCoordinateReferenceSystem(), crsAxes) : null;
            if (source.isDefined(8)) {
                int[] gridAxesToRemove = gridAxes.stream().toArray();
                this.removedGridToCRS = this.filterGridToCRS(gridAxesToRemove, gridAxes, PixelInCell.CELL_CENTER, factory);
                this.removedCornerToCRS = this.filterGridToCRS(gridAxesToRemove, gridAxes, PixelInCell.CELL_CORNER, factory);
                return;
            }
        }
        this.removedGridToCRS = null;
        this.removedCornerToCRS = null;
    }

    private static Object[] filterCRS(CoordinateReferenceSystem crs, BitSet axes) throws FactoryException {
        int lower;
        int dim = crs.getCoordinateSystem().getDimension();
        Object[] components = new Object[dim];
        int count = 0;
        int upper = 0;
        while ((lower = axes.nextSetBit(upper)) >= 0) {
            if (lower != upper) {
                components[count++] = lower - upper;
            }
            upper = axes.nextClearBit(lower);
            for (CoordinateReferenceSystem c : CRS.selectComponents((CoordinateReferenceSystem)crs, (int[])ArraysExt.range(lower, upper))) {
                components[count++] = c;
            }
        }
        if (upper != dim) {
            components[count++] = dim - upper;
        }
        return ArraysExt.resize(components, count);
    }

    private MathTransform filterGridToCRS(int[] gridAxesToRemove, BitSet bitset, PixelInCell anchor, MathTransformFactory factory) throws FactoryException {
        MathTransform gridToCRS = this.sourceGeometry.getGridToCRS(anchor);
        TransformSeparator sep = new TransformSeparator(gridToCRS, factory);
        sep.addSourceDimensions(gridAxesToRemove);
        sep.addTargetDimensions(this.crsAxesToRemove);
        return PassThroughTransform.create((BitSet)bitset, (MathTransform)sep.separate(), (int)gridToCRS.getSourceDimensions(), (MathTransformFactory)factory);
    }

    private DimensionalityReduction(DimensionalityReduction source, Map<Integer, Long> slice) {
        this.sourceGeometry = source.sourceGeometry;
        this.reducedGeometry = source.reducedGeometry;
        this.gridAxesToPass = source.gridAxesToPass;
        this.crsAxesToRemove = source.crsAxesToRemove;
        this.componentsOfCRS = source.componentsOfCRS;
        this.removedGridToCRS = source.removedGridToCRS;
        this.removedCornerToCRS = source.removedCornerToCRS;
        this.sliceCoordinates = Map.copyOf(slice);
    }

    private static BitSet bitmask(int[] axes, int sourceDim) {
        BitSet bitmask = new BitSet(sourceDim);
        for (int dim : axes) {
            ArgumentChecks.ensureValidIndex(sourceDim, dim);
            bitmask.set(dim);
        }
        return bitmask;
    }

    public static DimensionalityReduction select(GridGeometry source, int ... gridAxesToPass) {
        ArgumentChecks.ensureNonNull("source", source);
        BitSet bitmask = DimensionalityReduction.bitmask(gridAxesToPass, source.getDimension());
        try {
            return new DimensionalityReduction(source, bitmask, null);
        }
        catch (FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)83, (Object)e));
        }
    }

    public static DimensionalityReduction select2D(GridGeometry source) {
        return DimensionalityReduction.select(source, 0, 1);
    }

    public static DimensionalityReduction remove(GridGeometry source, int ... gridAxesToRemove) {
        ArgumentChecks.ensureNonNull("source", source);
        int sourceDim = source.getDimension();
        BitSet bitmask = DimensionalityReduction.bitmask(gridAxesToRemove, sourceDim);
        bitmask.flip(0, sourceDim);
        try {
            return new DimensionalityReduction(source, bitmask, null);
        }
        catch (FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)83, (Object)e));
        }
    }

    public static DimensionalityReduction reduce(GridGeometry source) {
        ArgumentChecks.ensureNonNull("source", source);
        GridExtent extent = source.getExtent();
        int sourceDim = extent.getDimension();
        BitSet bitmask = new BitSet(sourceDim);
        for (int dim = 0; dim < sourceDim; ++dim) {
            if (extent.getLow(dim) == extent.getHigh(dim)) continue;
            bitmask.set(dim);
        }
        try {
            return new DimensionalityReduction(source, bitmask, null);
        }
        catch (FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)83, (Object)e));
        }
    }

    public boolean isIdentity() {
        return this.reducedGeometry == this.sourceGeometry;
    }

    public boolean isSlice() {
        return this.indexOfNonSlice() >= 0;
    }

    final void ensureIsSlice() throws SubspaceNotSpecifiedException {
        int dim = this.indexOfNonSlice();
        if (dim >= 0) {
            throw new SubspaceNotSpecifiedException(Resources.format((short)84, dim));
        }
    }

    private int indexOfNonSlice() {
        int i = this.gridAxesToPass.length - 1;
        GridExtent extent = this.sourceGeometry.getExtent();
        int dim = extent.getDimension();
        while (--dim >= 0) {
            if (i >= 0 && dim == this.gridAxesToPass[i]) {
                --i;
                continue;
            }
            if (this.sliceCoordinates.containsKey(dim) || extent.getLow(dim) == extent.getHigh(dim)) continue;
            return dim;
        }
        return -1;
    }

    public boolean isReduced(GridGeometry candidate) {
        int dim = candidate.extent == null && candidate.gridToCRS == null ? this.reducedGeometry.getTargetDimension() : this.reducedGeometry.getDimension();
        return candidate.getDimension() == dim;
    }

    public GridGeometry getReducedGridGeometry() {
        return this.reducedGeometry;
    }

    public GridGeometry getSourceGridGeometry() {
        return this.sourceGeometry;
    }

    private MathTransform getRemovedGridToCRS(PixelInCell anchor) {
        if (PixelInCell.CELL_CENTER.equals(anchor)) {
            return this.removedGridToCRS;
        }
        if (PixelInCell.CELL_CORNER.equals(anchor)) {
            return this.removedCornerToCRS;
        }
        return PixelTranslation.translate(this.removedGridToCRS, PixelInCell.CELL_CENTER, anchor);
    }

    public int[] getSelectedDimensions() {
        return (int[])this.gridAxesToPass.clone();
    }

    public Map<Integer, Long> getSliceCoordinates() {
        return this.sliceCoordinates;
    }

    final int toReducedDimension(int dim) {
        return Arrays.binarySearch(this.gridAxesToPass, dim);
    }

    final int toSourceDimension(int dim) {
        return this.gridAxesToPass[dim];
    }

    private int toRemovedDimension(int i) {
        return i < this.crsAxesToRemove.length ? this.crsAxesToRemove[i] : -1;
    }

    private static boolean ensureSameAxes(GridExtent expected, GridExtent source) {
        if (source == null) {
            return true;
        }
        if (expected != null) {
            expected.ensureSameAxes(source, "source");
            if (expected.equals(source, ComparisonMode.IGNORE_METADATA)) {
                return true;
            }
        }
        return false;
    }

    private static boolean assertSameCRS(GridGeometry expected, CoordinateReferenceSystem actual) {
        CoordinateReferenceSystem crs;
        if (actual != null && expected.isDefined(1) && (crs = expected.getCoordinateReferenceSystem()) != null) {
            return Utilities.deepEquals(crs, actual, ComparisonMode.DEBUG);
        }
        return true;
    }

    @Override
    public DirectPosition apply(DirectPosition source) {
        if (source != null) {
            ArgumentChecks.ensureDimensionMatches("source", this.sourceGeometry.getTargetDimension(), source);
            assert (DimensionalityReduction.assertSameCRS(this.sourceGeometry, source.getCoordinateReferenceSystem())) : source;
            if (!this.isIdentity()) {
                GeneralDirectPosition reduced = new GeneralDirectPosition(this.reducedGeometry.getTargetDimension());
                int dim = -1;
                int remCounter = 0;
                int removedAxis = this.crsAxesToRemove[0];
                for (int i = 0; i < reduced.coordinates.length; ++i) {
                    while (++dim == removedAxis) {
                        removedAxis = this.toRemovedDimension(++remCounter);
                    }
                    reduced.coordinates[i] = source.getOrdinate(dim);
                }
                return reduced;
            }
        }
        return source;
    }

    @Override
    public GridExtent apply(GridExtent source) {
        if (source == null) {
            return null;
        }
        if (DimensionalityReduction.ensureSameAxes(this.sourceGeometry.extent, source)) {
            return this.reducedGeometry.extent;
        }
        return this.isIdentity() ? source : source.selectDimensions(this.gridAxesToPass);
    }

    @Override
    public GridGeometry apply(GridGeometry source) {
        if (source == null) {
            return null;
        }
        if (DimensionalityReduction.ensureSameAxes(this.sourceGeometry.extent, source.extent)) {
            return this.reducedGeometry;
        }
        return this.isIdentity() ? source : source.selectDimensions(this.gridAxesToPass);
    }

    @Override
    public GridCoverage apply(GridCoverage source) {
        ArgumentChecks.ensureNonNull("source", source);
        DimensionalityReduction.ensureSameAxes(this.sourceGeometry.extent, source.getGridGeometry().extent);
        return this.isIdentity() ? source : new ReducedGridCoverage(source, this);
    }

    public GridExtent reverse(GridExtent reduced) {
        if (DimensionalityReduction.ensureSameAxes(this.reducedGeometry.extent, reduced) && this.sliceCoordinates.isEmpty()) {
            return this.sourceGeometry.extent;
        }
        if (this.isIdentity()) {
            return reduced;
        }
        GridExtent source = this.sourceGeometry.getExtent();
        long[] coordinates = source.getCoordinates();
        int m = coordinates.length >>> 1;
        this.sliceCoordinates.forEach((dim, slice) -> {
            coordinates[dim.intValue()] = slice;
            coordinates[dim.intValue() + m] = slice;
        });
        if (reduced != null) {
            for (int i = 0; i < this.gridAxesToPass.length; ++i) {
                int dim2 = this.gridAxesToPass[i];
                coordinates[dim2] = reduced.getLow(i);
                coordinates[dim2 + m] = reduced.getHigh(i);
            }
        }
        return new GridExtent(source, coordinates);
    }

    public GridGeometry reverse(GridGeometry reduced) {
        GridExtent extent;
        GridExtent gridExtent = extent = reduced != null ? reduced.extent : null;
        if (DimensionalityReduction.ensureSameAxes(this.reducedGeometry.extent, extent) && this.sliceCoordinates.isEmpty()) {
            return this.sourceGeometry;
        }
        if (this.isIdentity()) {
            return reduced;
        }
        CoordinateReferenceSystem crs = null;
        if (reduced.isDefined(1) && this.sourceGeometry.isDefined(1)) {
            CoordinateReferenceSystem reducedCRS = reduced.getCoordinateReferenceSystem();
            if (Utilities.equalsIgnoreMetadata(this.reducedGeometry.getCoordinateReferenceSystem(), reducedCRS)) {
                crs = this.sourceGeometry.getCoordinateReferenceSystem();
            } else {
                FactoryException cause = null;
                try {
                    crs = this.fullCRS(reducedCRS);
                }
                catch (FactoryException e) {
                    cause = e;
                }
                if (crs == null) {
                    throw new IllegalGridGeometryException(Resources.format((short)83, (Object)cause));
                }
            }
        }
        int targetDim = this.sourceGeometry.getTargetDimension();
        double[] lowerCorner = new double[targetDim];
        double[] upperCorner = new double[targetDim];
        double[] resolution = new double[targetDim];
        long nonLinears = 0L;
        int reducedDim = 0;
        int remCounter = 0;
        int removedAxis = this.crsAxesToRemove[0];
        for (int i = 0; i < targetDim; ++i) {
            GridGeometry source;
            int dim;
            if (i == removedAxis) {
                dim = removedAxis;
                source = this.sourceGeometry;
                removedAxis = this.toRemovedDimension(++remCounter);
            } else {
                dim = reducedDim++;
                source = reduced;
            }
            lowerCorner[i] = source.envelope.getLower(dim);
            upperCorner[i] = source.envelope.getUpper(dim);
            double d = resolution[i] = source.resolution != null ? source.resolution[dim] : Double.NaN;
            if ((source.nonLinears & Numerics.bitmask(dim)) == 0L) continue;
            nonLinears |= Numerics.bitmask(i);
        }
        return new GridGeometry(this.reverse(extent), this.fullGridToCRS(reduced, PixelInCell.CELL_CENTER), this.fullGridToCRS(reduced, PixelInCell.CELL_CORNER), new ImmutableEnvelope(lowerCorner, upperCorner, crs), ArraysExt.allEquals(resolution, Double.NaN) ? null : resolution, nonLinears);
    }

    private CoordinateReferenceSystem fullCRS(CoordinateReferenceSystem reduced) throws FactoryException {
        if (this.componentsOfCRS == null) {
            return null;
        }
        CoordinateReferenceSystem[] components = new CoordinateReferenceSystem[this.componentsOfCRS.length];
        int lower = 0;
        for (int i = 0; i < components.length; ++i) {
            Object element = this.componentsOfCRS[i];
            if (element instanceof CoordinateReferenceSystem) {
                components[i] = (CoordinateReferenceSystem)element;
                continue;
            }
            int upper = lower + (Integer)element;
            components[i] = CRS.getComponentAt((CoordinateReferenceSystem)reduced, (int)lower, (int)upper);
            lower = upper;
        }
        return CRS.compound((CoordinateReferenceSystem[])components);
    }

    private MathTransform fullGridToCRS(GridGeometry reduced, PixelInCell anchor) {
        MathTransform removed = this.getRemovedGridToCRS(anchor);
        if (removed == null || !reduced.isDefined(8)) {
            return null;
        }
        MathTransform gridToCRS = reduced.getGridToCRS(anchor);
        if (Utilities.equalsIgnoreMetadata(this.reducedGeometry.getGridToCRS(anchor), gridToCRS)) {
            return this.sourceGeometry.getGridToCRS(anchor);
        }
        gridToCRS = MathTransforms.passThrough((int[])this.gridAxesToPass, (MathTransform)gridToCRS, (int)removed.getTargetDimensions());
        return MathTransforms.concatenate((MathTransform)removed, (MathTransform)gridToCRS);
    }

    public DimensionalityReduction withSlicePoint(long[] point) {
        ArgumentChecks.ensureNonNull("point", point);
        GridExtent extent = this.sourceGeometry.getExtent();
        int sourceDim = extent.getDimension();
        ArgumentChecks.ensureDimensionMatches("slicePoint", sourceDim, extent);
        HashMap<Integer, Long> slices = new HashMap<Integer, Long>();
        for (int dim = 0; dim < sourceDim; ++dim) {
            long low = extent.getLow(dim);
            long high = extent.getHigh(dim);
            long value = point[dim];
            if (value < low || value > high) {
                String b = Arrays.toString(point);
                b = b.substring(1, b.length() - 1);
                throw new PointOutsideCoverageException(Resources.format((short)21, extent.getAxisIdentification(dim, dim), low, high, b));
            }
            if (low == high || this.toReducedDimension(dim) >= 0) continue;
            slices.put(dim, value);
        }
        return slices.equals(this.sliceCoordinates) ? this : new DimensionalityReduction(this, slices);
    }

    public DimensionalityReduction withSliceByRatio(double ratio) {
        ArgumentChecks.ensureBetween("ratio", 0.0, 1.0, ratio);
        GridExtent extent = this.sourceGeometry.getExtent();
        int sourceDim = extent.getDimension();
        HashMap<Integer, Long> slices = new HashMap<Integer, Long>();
        for (int dim = 0; dim < sourceDim; ++dim) {
            if (this.toReducedDimension(dim) >= 0 || extent.getLow(dim) == extent.getHigh(dim)) continue;
            slices.put(dim, extent.getRelative(dim, ratio));
        }
        return slices.equals(this.sliceCoordinates) ? this : new DimensionalityReduction(this, slices);
    }
}

