/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class CompareToIntegerConstant
extends Expression
implements ComparisonExpression {
    private Expression operand;
    private long comparand;
    private int operator;

    public CompareToIntegerConstant(Expression operand, int operator, long comparand) {
        this.operand = operand;
        this.operator = operator;
        this.comparand = comparand;
        this.adoptChildExpression(operand);
    }

    public Expression getOperand() {
        return this.operand;
    }

    public long getComparand() {
        return this.comparand;
    }

    public int getComparisonOperator() {
        return this.operator;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    public int computeSpecialProperties() {
        return 0x400000;
    }

    public int computeDependencies() {
        return this.operand.getDependencies();
    }

    public Expression copy() {
        return new CompareToIntegerConstant(this.operand.copy(), this.operator, this.comparand);
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (original == this.operand) {
            this.operand = replacement;
            return true;
        }
        return false;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        NumericValue n = (NumericValue)this.operand.evaluateItem(context);
        if (n.isNaN()) {
            return this.operator == 45;
        }
        int c = n.compareTo(this.comparand);
        switch (this.operator) {
            case 44: {
                return c == 0;
            }
            case 45: {
                return c != 0;
            }
            case 46: {
                return c > 0;
            }
            case 47: {
                return c < 0;
            }
            case 48: {
                return c >= 0;
            }
            case 49: {
                return c <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    protected int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("compareToInteger");
        destination.emitAttribute("op", Token.tokens[this.operator]);
        destination.emitAttribute("value", this.comparand + "");
        this.operand.explain(destination);
        destination.endElement();
    }

    public AtomicComparer getAtomicComparer() {
        return DoubleSortComparer.getInstance();
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public Expression[] getOperands() {
        return new Expression[]{this.operand, Literal.makeLiteral(Int64Value.makeIntegerValue(this.comparand))};
    }

    public boolean convertsUntypedToOther() {
        return true;
    }
}

