/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.TECore;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.index.TestEntry;
import com.occamlab.te.util.TEPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RecordTestResult {
    private static final String UT_F8 = "UTF-8";
    private static final String A_TRUE = "True";
    private static final String RECORD = "Record";
    private static final String TIME = "Time";
    private static final String RESULT = "Result";
    private static final String NAME = "Name";
    private static final String NO = "no";
    private static final String XML = "xml";
    private static final String YES = "yes";
    private static final String ERROR_ON__RECORDING_AT_STARTING_ = "Error on Recording at starting :";
    private static final String ERROR_ON_SAVE_THE__RECORDING__ = "Error on save the Recording : ";
    private static final String ERROR_LOGLOGTXT = "/error_log/log.txt";
    private static final String SEE_THE_DETAIL_ERROR__REPORT_ = "\t\t\tSee the detail error Report ";
    private static final String SEE_THE_DETAIL_TEST__REPORT_ = "\t\t\tSee the detail test Report ";
    private static final String LOGXML = "/log.xml";
    private static final String TESTNG = "/testng";
    private static final String PATH = "PATH";

    public void detailTestPath() {
        File report_path = new File(System.getProperty(PATH) + TESTNG);
        if (!report_path.exists()) {
            System.out.println(SEE_THE_DETAIL_TEST__REPORT_ + System.getProperty(PATH) + LOGXML);
            File path = new File(System.getProperty(PATH) + ERROR_LOGLOGTXT);
            if (path.exists()) {
                System.out.println(SEE_THE_DETAIL_ERROR__REPORT_ + System.getProperty(PATH) + ERROR_LOGLOGTXT);
            }
        }
    }

    public void recordingStartCheck(SuiteEntry suite) throws Exception {
        if (null != suite && SetupOptions.recordingInfo(suite.getLocalName())) {
            TECore.icFactory = DocumentBuilderFactory.newInstance();
            TECore.icFactory.setExpandEntityReferences(false);
            try {
                TECore.icBuilder = TECore.icFactory.newDocumentBuilder();
                TECore.doc = TECore.icBuilder.newDocument();
                TECore.mainRootElement = TECore.doc.createElement("Requests");
                TECore.doc.appendChild(TECore.mainRootElement);
            }
            catch (Exception e) {
                System.out.println(ERROR_ON__RECORDING_AT_STARTING_ + e.toString());
            }
        }
    }

    public void recordingStartClause(SuiteEntry suite) throws Exception {
        if (null != suite && SetupOptions.recordingInfo(suite.getLocalName())) {
            TECore.icFactoryClause = DocumentBuilderFactory.newInstance();
            TECore.icFactoryClause.setExpandEntityReferences(false);
            try {
                TECore.icBuilderClause = TECore.icFactoryClause.newDocumentBuilder();
                TECore.docClause = TECore.icBuilder.newDocument();
                TECore.mainRootElementClause = TECore.docClause.createElement("Requests");
                TECore.docClause.appendChild(TECore.mainRootElementClause);
            }
            catch (Exception e) {
                System.out.println(ERROR_ON__RECORDING_AT_STARTING_ + e.toString());
            }
        }
    }

    public void saveRecordingData(SuiteEntry suite, File dirPath) throws Exception {
        TEPath tpath;
        if (dirPath != null && !(tpath = new TEPath(dirPath.getAbsolutePath())).isValid()) {
            throw new IllegalArgumentException("Invalid argument to saveRecordingData: dirPath = " + dirPath.getAbsolutePath());
        }
        if (dirPath != null && null != suite && SetupOptions.recordingInfo(suite.getLocalName())) {
            try {
                DOMSource source = new DOMSource(TECore.doc);
                TransformerFactory xformFactory = TransformerFactory.newInstance();
                xformFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer idTransform = xformFactory.newTransformer();
                idTransform.setOutputProperty("method", XML);
                idTransform.setOutputProperty("encoding", UT_F8);
                idTransform.setOutputProperty("indent", YES);
                FileOutputStream report_logs = new FileOutputStream(new File(dirPath.getAbsolutePath() + "/result_log1.xml"));
                StreamResult output = new StreamResult(report_logs);
                idTransform.transform(source, output);
                ((OutputStream)report_logs).close();
                BufferedReader bufferedReader = null;
                BufferedWriter bufferedWriter = null;
                bufferedReader = new BufferedReader(new FileReader(dirPath.getAbsolutePath() + "/result_log1.xml"));
                bufferedWriter = new BufferedWriter(new FileWriter(dirPath.getAbsolutePath() + "/result_log.xml"));
                String dataString = "";
                while ((dataString = bufferedReader.readLine()) != null) {
                    dataString = dataString.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
                    bufferedWriter.write(dataString);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                bufferedReader.close();
                bufferedWriter.close();
                TECore.methodCount = 0;
                TECore.rootTestName.clear();
                File file = new File(dirPath.getAbsolutePath() + "/result_log1.xml");
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                System.out.println(ERROR_ON_SAVE_THE__RECORDING__ + e.toString());
            }
        }
    }

    public void saveRecordingClause(SuiteEntry suite, File dirPath) throws Exception {
        TEPath tpath;
        if (dirPath != null && !(tpath = new TEPath(dirPath.getAbsolutePath())).isValid()) {
            throw new IllegalArgumentException("TEPath error on path " + dirPath.getAbsolutePath());
        }
        if (dirPath != null && null != suite && SetupOptions.recordingInfo(suite.getLocalName())) {
            try {
                DOMSource source = new DOMSource(TECore.docClause);
                TransformerFactory xformFactory = TransformerFactory.newInstance();
                xformFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer idTransform = xformFactory.newTransformer();
                idTransform.setOutputProperty("method", XML);
                idTransform.setOutputProperty("encoding", UT_F8);
                idTransform.setOutputProperty("indent", YES);
                FileOutputStream report_logs = new FileOutputStream(new File(dirPath.getAbsolutePath() + "/result_log1.xml"));
                StreamResult output = new StreamResult(report_logs);
                idTransform.transform(source, output);
                ((OutputStream)report_logs).close();
                BufferedReader bufferedReader = null;
                BufferedWriter bufferedWriter = null;
                bufferedReader = new BufferedReader(new FileReader(dirPath.getAbsolutePath() + "/result_log1.xml"));
                bufferedWriter = new BufferedWriter(new FileWriter(dirPath.getAbsolutePath() + "/result_clause.xml"));
                String dataString = "";
                while ((dataString = bufferedReader.readLine()) != null) {
                    dataString = dataString.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
                    bufferedWriter.write(dataString);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
                bufferedReader.close();
                bufferedWriter.close();
                File file = new File(dirPath.getAbsolutePath() + "/result_log1.xml");
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                System.out.println(ERROR_ON_SAVE_THE__RECORDING__ + e.toString());
            }
        }
    }

    public static Node getMethod() {
        Element testRequest = TECore.doc.createElement("Request");
        testRequest.setAttribute(NO, String.valueOf(TECore.methodCount));
        testRequest.appendChild(RecordTestResult.getMethodElements(TECore.doc, testRequest, "Assertion", TECore.assertionMsz));
        testRequest.appendChild(RecordTestResult.getMethodElements(TECore.doc, testRequest, "URL", TECore.pathURL));
        testRequest.appendChild(RecordTestResult.getMethodElements(TECore.doc, testRequest, "Message", TECore.messageTest));
        return testRequest;
    }

    public static Node getClause() {
        Element testRequest = TECore.docClause.createElement("Request");
        testRequest.setAttribute(NO, String.valueOf(TECore.rootNo));
        testRequest.appendChild(RecordTestResult.getClauseElements(TECore.docClause, testRequest, "TESTNAME", TECore.TESTNAME));
        testRequest.appendChild(RecordTestResult.getClauseElements(TECore.docClause, testRequest, "Clause", TECore.Clause));
        testRequest.appendChild(RecordTestResult.getClauseElements(TECore.docClause, testRequest, "Purpose", TECore.Purpose));
        return testRequest;
    }

    public static Node getClauseElements(Document doc, Element element, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value));
        return node;
    }

    public static Node getMethodElements(Document doc, Element element, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value));
        return node;
    }

    public void storeStartTestDetail(TestEntry test, File dirPath) throws Exception {
        TEPath tpath;
        if (dirPath != null && !(tpath = new TEPath(dirPath.getAbsolutePath())).isValid()) {
            throw new IllegalArgumentException("TEPath error on path " + dirPath.getAbsolutePath());
        }
        if (dirPath != null && A_TRUE.equals(System.getProperty(RECORD))) {
            if (TECore.testCount != 0) {
                JSONObject objBeforeTest = new JSONObject();
                objBeforeTest.put((Object)NAME, (Object)test.getName());
                objBeforeTest.put((Object)RESULT, (Object)"");
                OutputStreamWriter writerBefore = new OutputStreamWriter((OutputStream)new FileOutputStream(dirPath.getAbsolutePath() + "/test_result.txt", true), StandardCharsets.UTF_8);
                try (BufferedWriter fbwBefore = new BufferedWriter(writerBefore);){
                    fbwBefore.write(objBeforeTest.toString());
                    fbwBefore.newLine();
                    fbwBefore.close();
                }
            } else {
                ++TECore.testCount;
                TECore.nameOfTest = test.getName();
            }
        }
    }

    public void storeFinalTestDetail(TestEntry test, DateFormat dateFormat, Calendar cal, File dirPath) throws Exception {
        TEPath tpath;
        if (dirPath != null && !(tpath = new TEPath(dirPath.getAbsolutePath())).isValid()) {
            throw new IllegalArgumentException("TEPath error on path " + dirPath.getAbsolutePath());
        }
        if (dirPath != null && A_TRUE.equals(System.getProperty(RECORD))) {
            if (!TECore.nameOfTest.equals(test.getName())) {
                String result = "";
                JSONObject obj = new JSONObject();
                obj.put((Object)NAME, (Object)test.getName());
                result = TECore.getResultDescription(test.getResult()).contains("Inherited") && test.getName().contains("GetMap") ? "Passed" : TECore.getResultDescription(test.getResult());
                obj.put((Object)RESULT, (Object)result);
                obj.put((Object)TIME, (Object)dateFormat.format(cal.getTime()));
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dirPath.getAbsolutePath() + "/test_result.txt", true), StandardCharsets.UTF_8);
                try (BufferedWriter fbw = new BufferedWriter(writer);){
                    fbw.write(obj.toString());
                    fbw.newLine();
                    fbw.close();
                }
            } else {
                TECore.testCount = 0;
            }
        }
    }
}

