/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.object.DefaultTemporalGeometricPrimitive;
import org.geotoolkit.temporal.object.TemporalUtilities;
import org.opengis.temporal.Instant;
import org.opengis.temporal.TemporalPosition;

@XmlType(name="TimeInstant_Type", propOrder={"date"})
@XmlRootElement(name="TimeInstant")
public class DefaultInstant
extends DefaultTemporalGeometricPrimitive
implements Instant {
    private final Date date;
    private final TemporalPosition temporalPosition;

    public DefaultInstant() {
        this.date = null;
        this.temporalPosition = null;
    }

    public DefaultInstant(Map<String, ?> properties, Date date) throws IllegalArgumentException {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"position", (Object)date);
        this.date = date;
        this.temporalPosition = null;
    }

    public DefaultInstant(Map<String, ?> properties, TemporalPosition temporalPosition) throws IllegalArgumentException {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"position", (Object)temporalPosition);
        this.date = null;
        this.temporalPosition = temporalPosition;
    }

    private DefaultInstant(Instant object) {
        if (object != null) {
            this.date = object.getDate();
            this.temporalPosition = object.getTemporalPosition();
        } else {
            this.date = null;
            this.temporalPosition = null;
        }
    }

    public static DefaultInstant castOrCopy(Instant object) {
        if (object == null || object instanceof DefaultInstant) {
            return (DefaultInstant)object;
        }
        return new DefaultInstant(object);
    }

    @XmlElement(name="timePosition", required=true)
    public Date getDate() {
        return this.date;
    }

    public TemporalPosition getTemporalPosition() {
        return this.temporalPosition;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultInstant) {
            DefaultInstant that = (DefaultInstant)((Object)object);
            return TemporalUtilities.dateEquals(this.date, that.date) && Objects.equals(this.temporalPosition, that.temporalPosition);
        }
        return false;
    }

    protected long computeHashCode() {
        int hash = 5;
        hash = 37 * hash + (this.date != null ? this.date.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString()).append('\n').append("Instant:").append('\n');
        if (this.date != null) {
            s.append("date:").append(this.date).append('\n');
        }
        if (this.temporalPosition != null) {
            s.append("temporalPosition :").append(this.temporalPosition).append('\n');
        }
        return s.toString();
    }
}

