/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.temporal.OrdinalEra;
import org.opengis.temporal.OrdinalReferenceSystem;
import org.opengis.temporal.TemporalReferenceSystem;

@XmlType(name="TimeOrdinalReferenceSystem_Type", propOrder={"ordinalEraSequence"})
@XmlRootElement(name="TimeOrdinalReferenceSystem")
public class DefaultOrdinalReferenceSystem
extends DefaultTemporalReferenceSystem
implements OrdinalReferenceSystem {
    private final Collection<OrdinalEra> ordinalEraSequence;

    public DefaultOrdinalReferenceSystem(Map<String, ?> properties, Collection<OrdinalEra> ordinalEraSequence) {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"ordinalEraSequence", ordinalEraSequence);
        this.ordinalEraSequence = ordinalEraSequence;
    }

    private DefaultOrdinalReferenceSystem() {
        this.ordinalEraSequence = null;
    }

    public DefaultOrdinalReferenceSystem(OrdinalReferenceSystem object) {
        super((TemporalReferenceSystem)object);
        if (object != null) {
            Collection ordinalEraSeq = object.getComponents();
            ArgumentChecks.ensureNonNull((String)"ordinalEraSequence", (Object)ordinalEraSeq);
            this.ordinalEraSequence = ordinalEraSeq;
        } else {
            this.ordinalEraSequence = null;
        }
    }

    public static DefaultOrdinalReferenceSystem castOrCopy(OrdinalReferenceSystem object) {
        if (object == null || object instanceof DefaultTemporalCoordinateSystem) {
            return (DefaultOrdinalReferenceSystem)object;
        }
        return new DefaultOrdinalReferenceSystem(object);
    }

    @XmlElement(name="component", required=true)
    public Collection<OrdinalEra> getComponents() {
        return this.ordinalEraSequence;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        boolean sup = super.equals(object, mode);
        if (!sup) {
            return false;
        }
        if (object instanceof DefaultOrdinalReferenceSystem && super.equals(object)) {
            DefaultOrdinalReferenceSystem that = (DefaultOrdinalReferenceSystem)((Object)object);
            return Objects.equals(this.ordinalEraSequence, that.ordinalEraSequence);
        }
        return false;
    }

    protected long computeHashCode() {
        return 37 * this.getName().hashCode() * (this.ordinalEraSequence != null ? this.ordinalEraSequence.hashCode() : 0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString()).append('\n').append("OrdinalReferenceSystem:").append('\n');
        if (this.ordinalEraSequence != null) {
            s.append("ordinalEraSequence:").append(this.ordinalEraSequence).append('\n');
        }
        return super.toString().concat("\n").concat(s.toString());
    }
}

