/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class JTSMapping {
    private static final GeometryFactory GF = JTS.getFactory();

    private JTSMapping() {
    }

    public static <T extends Geometry> T convertType(Geometry geom, Class<T> targetClass) {
        if (geom == null) {
            return null;
        }
        if (targetClass.isInstance(geom)) {
            return (T)geom;
        }
        Geometry result = targetClass == Point.class ? JTSMapping.convertToPoint(geom) : (targetClass == MultiPoint.class ? JTSMapping.convertToMultiPoint(geom) : (targetClass == LineString.class ? JTSMapping.convertToLineString(geom) : (targetClass == MultiLineString.class ? JTSMapping.convertToMultiLineString(geom) : (targetClass == Polygon.class ? JTSMapping.convertToPolygon(geom) : (targetClass == MultiPolygon.class ? JTSMapping.convertToMultiPolygon(geom) : (targetClass == GeometryCollection.class ? JTSMapping.convertToGeometryCollection(geom) : null))))));
        if (result != null) {
            result.setSRID(geom.getSRID());
            result.setUserData(geom.getUserData());
        }
        return (T)((Geometry)targetClass.cast(result));
    }

    private static Point convertToPoint(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToPoint((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToPoint((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToPoint((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToPoint((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToPoint((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToPoint((MultiPolygon)geom);
        }
        return null;
    }

    private static Point convertToPoint(Point pt) {
        return pt;
    }

    private static Point convertToPoint(MultiPoint pt) {
        return pt.getCentroid();
    }

    private static Point convertToPoint(LineString pt) {
        return pt.getCentroid();
    }

    private static Point convertToPoint(MultiLineString pt) {
        return pt.getCentroid();
    }

    private static Point convertToPoint(Polygon pt) {
        return pt.getCentroid();
    }

    private static Point convertToPoint(MultiPolygon pt) {
        return pt.getCentroid();
    }

    private static MultiPoint convertToMultiPoint(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToMultiPoint((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToMultiPoint((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToMultiPoint((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToMultiPoint((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToMultiPoint((MultiPolygon)geom);
        }
        return null;
    }

    private static MultiPoint convertToMultiPoint(Point pt) {
        return GF.createMultiPoint(new Point[]{pt});
    }

    private static MultiPoint convertToMultiPoint(MultiPoint pt) {
        return pt;
    }

    private static MultiPoint convertToMultiPoint(LineString pt) {
        return GF.createMultiPoint(pt.getCoordinates());
    }

    private static MultiPoint convertToMultiPoint(MultiLineString pt) {
        return GF.createMultiPoint(pt.getCoordinates());
    }

    private static MultiPoint convertToMultiPoint(Polygon pt) {
        return GF.createMultiPoint(pt.getCoordinates());
    }

    private static MultiPoint convertToMultiPoint(MultiPolygon pt) {
        return GF.createMultiPoint(pt.getCoordinates());
    }

    private static LineString convertToLineString(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToLineString((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToLineString((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToLineString((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToLineString((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToLineString((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToLineString((MultiPolygon)geom);
        }
        return null;
    }

    private static LineString convertToLineString(Point pt) {
        return GF.createLineString(new Coordinate[]{pt.getCoordinate(), pt.getCoordinate()});
    }

    private static LineString convertToLineString(MultiPoint pt) {
        Coordinate[] coords = pt.getCoordinates();
        if (coords.length == 1) {
            return GF.createLineString(new Coordinate[]{coords[0], coords[0]});
        }
        return GF.createLineString(coords);
    }

    private static LineString convertToLineString(LineString pt) {
        return pt;
    }

    private static LineString convertToLineString(MultiLineString pt) {
        return GF.createLineString(pt.getCoordinates());
    }

    private static LineString convertToLineString(Polygon pt) {
        return GF.createLineString(pt.getCoordinates());
    }

    private static LineString convertToLineString(MultiPolygon pt) {
        return GF.createLineString(pt.getCoordinates());
    }

    private static MultiLineString convertToMultiLineString(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToMultiLineString((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToMultiLineString((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToMultiLineString((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToMultiLineString((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToMultiLineString((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToMultiLineString((MultiPolygon)geom);
        }
        return null;
    }

    private static MultiLineString convertToMultiLineString(Point pt) {
        return JTSMapping.convertToMultiLineString(JTSMapping.convertToLineString(pt));
    }

    private static MultiLineString convertToMultiLineString(MultiPoint pt) {
        return JTSMapping.convertToMultiLineString(JTSMapping.convertToLineString(pt));
    }

    private static MultiLineString convertToMultiLineString(LineString pt) {
        return GF.createMultiLineString(new LineString[]{pt});
    }

    private static MultiLineString convertToMultiLineString(MultiLineString pt) {
        return pt;
    }

    private static MultiLineString convertToMultiLineString(Polygon pt) {
        int nbHoles = pt.getNumInteriorRing();
        ArrayList<LinearRing> strings = new ArrayList<LinearRing>(nbHoles + 1);
        strings.add(pt.getExteriorRing());
        for (int i = 0; i < nbHoles; ++i) {
            strings.add(pt.getInteriorRingN(i));
        }
        return GF.createMultiLineString(strings.toArray(new LineString[nbHoles + 1]));
    }

    private static MultiLineString convertToMultiLineString(MultiPolygon pt) {
        int n = pt.getNumGeometries();
        LineString[] geoms = new LineString[n];
        for (int i = 0; i < n; ++i) {
            geoms[i] = JTSMapping.convertToLineString(pt.getGeometryN(i));
        }
        return GF.createMultiLineString(geoms);
    }

    private static Polygon convertToPolygon(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToPolygon((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToPolygon((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToPolygon((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToPolygon((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToPolygon((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToPolygon((MultiPolygon)geom);
        }
        return null;
    }

    private static Polygon convertToPolygon(Point pt) {
        LinearRing ring = GF.createLinearRing(new Coordinate[]{pt.getCoordinate(), pt.getCoordinate(), pt.getCoordinate(), pt.getCoordinate()});
        return GF.createPolygon(ring, new LinearRing[0]);
    }

    private static Polygon convertToPolygon(MultiPoint pt) {
        return JTSMapping.convertToPolygon(JTSMapping.convertToLineString(pt));
    }

    private static Polygon convertToPolygon(LineString pt) {
        if (pt.isEmpty() || pt.isRing()) {
            return GF.createPolygon(GF.createLinearRing(pt.getCoordinates()), new LinearRing[0]);
        }
        Logger.getLogger("org.geotoolkit.geometry").log(Level.FINE, "LineString {0} is not a valid linear ring to build a polygon,", pt);
        return GF.createPolygon();
    }

    private static Polygon convertToPolygon(MultiLineString pt) {
        return JTSMapping.convertToPolygon(JTSMapping.convertToLineString(pt));
    }

    private static Polygon convertToPolygon(Polygon pt) {
        return pt;
    }

    private static Polygon convertToPolygon(MultiPolygon pt) {
        int nbGeom = pt.getNumGeometries();
        if (nbGeom == 0) {
            return GF.createPolygon();
        }
        if (nbGeom == 1) {
            return (Polygon)pt.getGeometryN(0);
        }
        return JTSMapping.convertToPolygon(pt.convexHull());
    }

    private static MultiPolygon convertToMultiPolygon(Geometry geom) {
        if (geom instanceof Point) {
            return JTSMapping.convertToMultiPolygon((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return JTSMapping.convertToMultiPolygon((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToMultiPolygon((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return JTSMapping.convertToMultiPolygon((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToMultiPolygon((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return JTSMapping.convertToMultiPolygon((MultiPolygon)geom);
        }
        return null;
    }

    private static MultiPolygon convertToMultiPolygon(Point pt) {
        return JTSMapping.convertToMultiPolygon(JTSMapping.convertToPolygon(pt));
    }

    private static MultiPolygon convertToMultiPolygon(MultiPoint pt) {
        return JTSMapping.convertToMultiPolygon(JTSMapping.convertToPolygon(pt));
    }

    private static MultiPolygon convertToMultiPolygon(LineString pt) {
        return JTSMapping.convertToMultiPolygon(JTSMapping.convertToPolygon(pt));
    }

    private static MultiPolygon convertToMultiPolygon(MultiLineString pt) {
        return JTSMapping.convertToMultiPolygon(JTSMapping.convertToPolygon(pt));
    }

    private static MultiPolygon convertToMultiPolygon(Polygon pt) {
        return GF.createMultiPolygon(new Polygon[]{pt});
    }

    private static MultiPolygon convertToMultiPolygon(MultiPolygon pt) {
        return pt;
    }

    private static GeometryCollection convertToGeometryCollection(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            return (GeometryCollection)geom;
        }
        if (geom instanceof Point) {
            return JTSMapping.convertToMultiPoint(geom);
        }
        if (geom instanceof LineString) {
            return JTSMapping.convertToMultiLineString(geom);
        }
        if (geom instanceof Polygon) {
            return JTSMapping.convertToMultiPolygon(geom);
        }
        return null;
    }

    public static Geometry preservePonctuals(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Object userData = geometry.getUserData();
        String geometryType = geometry.getGeometryType();
        if (!"Point".equals(geometryType) && !"MultiPoint".equals(geometryType)) {
            if ("GeometryCollection".equals(geometryType)) {
                GeometryCollection gc = (GeometryCollection)geometry;
                ArrayList<Point> parts = new ArrayList<Point>();
                int in = gc.getNumGeometries();
                for (int i = 0; i < in; ++i) {
                    Geometry cdt = JTSMapping.preservePonctuals(gc.getGeometryN(i));
                    if (cdt instanceof Point) {
                        parts.add((Point)cdt);
                        continue;
                    }
                    if (!(cdt instanceof MultiPoint)) continue;
                    MultiPoint mp = (MultiPoint)cdt;
                    int kn = mp.getNumGeometries();
                    for (int k = 0; k < kn; ++k) {
                        parts.add((Point)mp.getGeometryN(k));
                    }
                }
                int size = parts.size();
                geometry = size == 0 ? geometry.getFactory().createPoint() : (size == 1 ? (Geometry)parts.get(0) : geometry.getFactory().createMultiPoint(GeometryFactory.toPointArray(parts)));
                geometry.setUserData(userData);
            } else {
                geometry = geometry.getFactory().createPoint();
                geometry.setUserData(userData);
            }
        }
        return geometry;
    }

    public static Geometry preserveLinears(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Object userData = geometry.getUserData();
        String geometryType = geometry.getGeometryType();
        if (!("LineString".equals(geometryType) || "LinearRing".equals(geometryType) || "MultiLineString".equals(geometryType))) {
            if ("GeometryCollection".equals(geometryType)) {
                GeometryCollection gc = (GeometryCollection)geometry;
                ArrayList<LineString> parts = new ArrayList<LineString>();
                int in = gc.getNumGeometries();
                for (int i = 0; i < in; ++i) {
                    Geometry cdt = JTSMapping.preserveLinears(gc.getGeometryN(i));
                    if (cdt instanceof LineString) {
                        parts.add((LineString)cdt);
                        continue;
                    }
                    if (!(cdt instanceof MultiLineString)) continue;
                    MultiLineString mp = (MultiLineString)cdt;
                    int kn = mp.getNumGeometries();
                    for (int k = 0; k < kn; ++k) {
                        parts.add((LineString)mp.getGeometryN(k));
                    }
                }
                int size = parts.size();
                geometry = size == 0 ? geometry.getFactory().createLineString() : (size == 1 ? (Geometry)parts.get(0) : geometry.getFactory().createMultiLineString(GeometryFactory.toLineStringArray(parts)));
                geometry.setUserData(userData);
            } else {
                geometry = geometry.getFactory().createLineString();
                geometry.setUserData(userData);
            }
        }
        return geometry;
    }

    public static Geometry preservePolygonals(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Object userData = geometry.getUserData();
        String geometryType = geometry.getGeometryType();
        if (!"Polygon".equals(geometryType) && !"MultiPolygon".equals(geometryType)) {
            if ("GeometryCollection".equals(geometryType)) {
                GeometryCollection gc = (GeometryCollection)geometry;
                ArrayList<Polygon> parts = new ArrayList<Polygon>();
                int in = gc.getNumGeometries();
                for (int i = 0; i < in; ++i) {
                    Geometry cdt = JTSMapping.preservePolygonals(gc.getGeometryN(i));
                    if (cdt instanceof Polygon) {
                        parts.add((Polygon)cdt);
                        continue;
                    }
                    if (!(cdt instanceof MultiPolygon)) continue;
                    MultiPolygon mp = (MultiPolygon)cdt;
                    int kn = mp.getNumGeometries();
                    for (int k = 0; k < kn; ++k) {
                        parts.add((Polygon)mp.getGeometryN(k));
                    }
                }
                int size = parts.size();
                geometry = size == 0 ? geometry.getFactory().createPolygon() : (size == 1 ? (Geometry)parts.get(0) : geometry.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(parts)));
                geometry.setUserData(userData);
            } else {
                geometry = geometry.getFactory().createPolygon();
                geometry.setUserData(userData);
            }
        }
        return geometry;
    }
}

