/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.referencing.operation.MathTransform;

public final class JTSLineIterator
extends JTSGeometryIterator<LineString> {
    private CoordinateSequence coordinates;
    private int coordinateCount;
    private boolean isClosed;
    private int currentCoord = 0;
    private boolean done = false;

    public JTSLineIterator(LineString ls, MathTransform trs) {
        super(ls, trs);
        this.setGeometry(ls);
    }

    @Override
    public void setGeometry(LineString geom) {
        super.setGeometry(geom);
        if (geom != null) {
            this.coordinates = geom.getCoordinateSequence();
            this.coordinateCount = this.coordinates.size();
            this.isClosed = geom instanceof LinearRing;
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.done = false;
        this.currentCoord = 0;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (this.currentCoord == this.coordinateCount - 1 && !this.isClosed || this.currentCoord == this.coordinateCount && this.isClosed) {
            this.done = true;
        } else {
            ++this.currentCoord;
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = this.coordinates.getX(0);
            coords[1] = this.coordinates.getY(0);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount && this.isClosed) {
            return 4;
        }
        coords[0] = this.coordinates.getX(this.currentCoord);
        coords[1] = this.coordinates.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = (float)this.coordinates.getX(0);
            coords[1] = (float)this.coordinates.getY(0);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount && this.isClosed) {
            return 4;
        }
        coords[0] = (float)this.coordinates.getX(this.currentCoord);
        coords[1] = (float)this.coordinates.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }
}

