/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.coordinatesequence;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class GridAlignedFilter
implements CoordinateSequenceFilter {
    private final double offsetx;
    private final double offsety;
    private final double stepx;
    private final double stepy;
    private boolean removeColinear = true;
    private boolean createEmpty = false;
    private boolean removeSpikes = false;

    public GridAlignedFilter(double originx, double originy, double stepx, double stepy) {
        this.offsetx = originx;
        this.offsety = originy;
        this.stepx = stepx;
        this.stepy = stepy;
    }

    public void setRemoveColinear(boolean removeColinear) {
        this.removeColinear = removeColinear;
    }

    public boolean isRemoveColinear() {
        return this.removeColinear;
    }

    public void setCreateEmpty(boolean createEmpty) {
        this.createEmpty = createEmpty;
    }

    public boolean isCreateEmpty() {
        return this.createEmpty;
    }

    public void setRemoveSpikes(boolean removeSpikes) {
        this.removeSpikes = removeSpikes;
    }

    public boolean isRemoveSpikes() {
        return this.removeSpikes;
    }

    public Geometry alignAndSimplify(Geometry geometry) {
        return this.alignAndSimplify(geometry, this.createEmpty);
    }

    private Geometry alignAndSimplify(Geometry geometry, boolean createEmpty) {
        Geometry result;
        if (geometry == null || geometry.isEmpty()) {
            return geometry;
        }
        GeometryFactory gf = geometry.getFactory();
        Object userData = geometry.getUserData();
        if (geometry instanceof Point) {
            Point cdt = (Point)geometry;
            Coordinate coord = cdt.getCoordinate().copy();
            this.filter(coord);
            result = gf.createPoint(coord);
        } else if (geometry instanceof LinearRing) {
            LinearRing cdt = (LinearRing)geometry;
            CoordinateSequence coordinates = this.filterAndReduce(gf.getCoordinateSequenceFactory(), cdt.getCoordinateSequence(), createEmpty ? 0 : 3, true);
            if (this.removeSpikes) {
                coordinates = this.removeSpikes(gf.getCoordinateSequenceFactory(), coordinates, createEmpty ? 0 : 3, true);
            }
            result = coordinates.size() < 3 ? gf.createLinearRing() : gf.createLinearRing(coordinates);
        } else if (geometry instanceof LineString) {
            LineString cdt = (LineString)geometry;
            CoordinateSequence coordinates = this.filterAndReduce(gf.getCoordinateSequenceFactory(), cdt.getCoordinateSequence(), createEmpty ? 0 : 2, false);
            if (this.removeSpikes) {
                coordinates = this.removeSpikes(gf.getCoordinateSequenceFactory(), coordinates, createEmpty ? 0 : 2, false);
            }
            result = coordinates.size() < 2 ? gf.createLineString() : gf.createLineString(coordinates);
        } else if (geometry instanceof Polygon) {
            Polygon cdt = (Polygon)geometry;
            LinearRing exteriorRing = (LinearRing)this.alignAndSimplify(cdt.getExteriorRing(), createEmpty);
            if (createEmpty && exteriorRing.isEmpty()) {
                result = gf.createPolygon(exteriorRing);
            } else {
                int numInteriorRing = cdt.getNumInteriorRing();
                if (numInteriorRing == 0) {
                    result = gf.createPolygon(exteriorRing);
                } else {
                    ArrayList<LinearRing> holes = new ArrayList<LinearRing>(numInteriorRing);
                    for (int i = 0; i < numInteriorRing; ++i) {
                        LinearRing interiorRing = (LinearRing)this.alignAndSimplify(cdt.getInteriorRingN(i), true);
                        if (interiorRing.isEmpty()) continue;
                        holes.add(interiorRing);
                    }
                    result = gf.createPolygon(exteriorRing, holes.toArray(new LinearRing[holes.size()]));
                }
            }
            result = result.buffer(0.0);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint cdt = (MultiPoint)geometry;
            Coordinate[] coordinates = this.filterAndReduce(cdt.getCoordinates(), 1);
            result = gf.createMultiPointFromCoords(coordinates);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString cdt = (MultiLineString)geometry;
            int nb = cdt.getNumGeometries();
            ArrayList<LineString> geoms = new ArrayList<LineString>(nb);
            for (int i = 0; i < nb; ++i) {
                LineString ls = (LineString)this.alignAndSimplify((LineString)cdt.getGeometryN(i), createEmpty ? true : !geoms.isEmpty());
                if (ls.isEmpty()) continue;
                geoms.add(ls);
            }
            result = gf.createMultiLineString(geoms.toArray(new LineString[geoms.size()]));
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon cdt = (MultiPolygon)geometry;
            int nb = cdt.getNumGeometries();
            ArrayList<Geometry> geoms = new ArrayList<Geometry>(nb);
            boolean allPolygons = true;
            for (int i = 0; i < nb; ++i) {
                Geometry ls = this.alignAndSimplify((Polygon)cdt.getGeometryN(i), createEmpty ? true : !geoms.isEmpty());
                if (ls.isEmpty()) continue;
                if (ls instanceof GeometryCollection) {
                    GeometryCollection gc = (GeometryCollection)ls;
                    int n = gc.getNumGeometries();
                    for (int k = 0; k < n; ++k) {
                        Geometry cd = gc.getGeometryN(k);
                        geoms.add(cd);
                        allPolygons &= cd instanceof Polygon;
                    }
                    continue;
                }
                geoms.add(ls);
                allPolygons &= ls instanceof Polygon;
            }
            result = allPolygons ? gf.createMultiPolygon(geoms.toArray(new Polygon[geoms.size()])) : gf.createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection cdt = (GeometryCollection)geometry;
            int nb = cdt.getNumGeometries();
            ArrayList<Geometry> geoms = new ArrayList<Geometry>(nb);
            for (int i = 0; i < nb; ++i) {
                Geometry ls = this.alignAndSimplify(cdt.getGeometryN(i), createEmpty ? true : !geoms.isEmpty());
                if (ls.isEmpty()) continue;
                geoms.add(ls);
            }
            result = gf.createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
        } else {
            throw new IllegalArgumentException("Unexpected geometry type " + geometry.getClass().getName());
        }
        result.setUserData(userData);
        return result;
    }

    @Override
    public void filter(CoordinateSequence seq, int i) {
        Coordinate coordinate = seq.getCoordinate(i);
        double x = Math.rint((coordinate.x - this.offsetx) / this.stepx);
        double y = Math.rint((coordinate.y - this.offsety) / this.stepy);
        seq.setOrdinate(i, 0, this.stepx * x + this.offsetx);
        seq.setOrdinate(i, 1, this.stepy * y + this.offsety);
    }

    public Coordinate filter(Coordinate coordinate) {
        double x = Math.rint((coordinate.x - this.offsetx) / this.stepx);
        double y = Math.rint((coordinate.y - this.offsety) / this.stepy);
        coordinate.x = this.stepx * x + this.offsetx;
        coordinate.y = this.stepy * y + this.offsety;
        return coordinate;
    }

    public CoordinateSequence filterAndReduce(CoordinateSequenceFactory cf, CoordinateSequence cs, int minPoints, boolean isRing) {
        Coordinate first;
        int size = cs.size();
        if (size == 0) {
            return cs;
        }
        if (size == 1) {
            return cs.copy();
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(size);
        Coordinate previous = this.filter(cs.getCoordinateCopy(0));
        coords.add(previous);
        double lastSlopeX = Double.POSITIVE_INFINITY;
        double lastSlopeY = Double.POSITIVE_INFINITY;
        for (int i = 1; i < size; ++i) {
            Coordinate c = this.filter(cs.getCoordinateCopy(i));
            if (c.x == previous.x && c.y == previous.y) continue;
            if (this.removeColinear) {
                if (lastSlopeX == Double.POSITIVE_INFINITY) {
                    lastSlopeX = c.x - previous.x;
                    lastSlopeY = c.y - previous.y;
                    coords.add(c);
                    previous = c;
                    continue;
                }
                double slopeX = c.x - previous.x;
                double slopeY = c.y - previous.y;
                if (slopeX * lastSlopeY == lastSlopeX * slopeY && Math.signum(slopeX) == Math.signum(lastSlopeX) && Math.signum(slopeY) == Math.signum(lastSlopeY)) {
                    previous.setCoordinate(c);
                    continue;
                }
                coords.add(c);
                previous = c;
                lastSlopeX = slopeX;
                lastSlopeY = slopeY;
                continue;
            }
            coords.add(c);
            previous = c;
        }
        while (coords.size() < minPoints) {
            coords.add(previous.copy());
        }
        if (isRing && minPoints > 0 && !previous.equals(first = (Coordinate)coords.get(0))) {
            coords.add(first.copy());
        }
        return cf.create(coords.toArray(new Coordinate[0]));
    }

    public Coordinate[] filterAndReduce(Coordinate[] cs, int minPoints) {
        int size = cs.length;
        if (size == 0) {
            return cs;
        }
        if (size == 1) {
            return new Coordinate[]{cs[0].copy()};
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(size);
        Coordinate previous = this.filter(cs[0].copy());
        coords.add(previous);
        for (int i = 1; i < size; ++i) {
            Coordinate c = this.filter(cs[i].copy());
            if (c.x == previous.x && c.y == previous.y) continue;
            coords.add(c);
            previous = c;
        }
        while (coords.size() < minPoints) {
            coords.add(previous.copy());
        }
        return coords.toArray(new Coordinate[coords.size()]);
    }

    public CoordinateSequence removeSpikes(CoordinateSequenceFactory cf, CoordinateSequence cs, int minPoints, boolean isRing) {
        Coordinate first;
        int size = cs.size();
        if (size == 0) {
            return cs;
        }
        if (size == 1) {
            return cs.copy();
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(size);
        Coordinate previous2 = cs.getCoordinateCopy(0);
        Coordinate previous1 = cs.getCoordinateCopy(1);
        coords.add(previous2);
        for (int i = 2; i < size; ++i) {
            Coordinate c = cs.getCoordinateCopy(i);
            if (previous2.x == c.x && previous2.y == c.y && Math.abs(previous1.x - previous2.x) < this.stepx * 1.9 && Math.abs(previous1.y - previous2.y) < this.stepy * 1.9) {
                ++i;
                while (i < size) {
                    c = cs.getCoordinateCopy(i);
                    if (previous2.x == c.x && previous2.y == c.y) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                coords.add(previous1);
                previous2 = previous1;
            }
            previous1 = c;
        }
        coords.add(previous1);
        if (isRing && !(first = (Coordinate)coords.get(0)).equals(previous1)) {
            coords.add(first.copy());
        }
        while (coords.size() < minPoints) {
            coords.add(((Coordinate)coords.get(coords.size() - 1)).copy());
        }
        return cf.create(coords.toArray(new Coordinate[0]));
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return true;
    }
}

