/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Arrays;
import org.apache.sis.geometry.AbstractDirectPosition;

public abstract class DirectPositionView
extends AbstractDirectPosition {
    public int offset;
    final int dimension;

    DirectPositionView(int offset, int dimension) {
        this.offset = offset;
        this.dimension = dimension;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public static final class Float
    extends DirectPositionView {
        private final float[] coordinates;

        public Float(float[] coordinates, int offset, int dimension) {
            super(offset, dimension);
            this.coordinates = coordinates;
        }

        public double getOrdinate(int dim) {
            assert (dim >= 0 && dim < this.dimension) : dim;
            return this.coordinates[this.offset + dim];
        }
    }

    public static final class Double
    extends DirectPositionView {
        private final double[] coordinates;

        public Double(double[] coordinates) {
            super(0, coordinates.length);
            this.coordinates = coordinates;
        }

        public Double(double[] coordinates, int offset, int dimension) {
            super(offset, dimension);
            this.coordinates = coordinates;
        }

        public double getOrdinate(int dim) {
            assert (dim >= 0 && dim < this.dimension) : dim;
            return this.coordinates[this.offset + dim];
        }

        @Override
        public double[] getCoordinate() {
            return Arrays.copyOfRange(this.coordinates, this.offset, this.offset + this.dimension);
        }
    }
}

