/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Arrays;
import javax.measure.Quantity;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;

final class DatumShiftGridCompressed<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGridFile<C, T> {
    private static final long serialVersionUID = 1889111858140209014L;
    private final double[] averages;
    private final short[][] data;
    private final double scale;

    private DatumShiftGridCompressed(DatumShiftGridFile<C, T> grid, double[] averages, short[][] data, double scale) {
        super(grid);
        this.averages = averages;
        this.data = data;
        this.scale = scale;
    }

    static <C extends Quantity<C>, T extends Quantity<T>> DatumShiftGridFile<C, T> compress(DatumShiftGridFile.Float<C, T> grid, double[] averages, double scale) {
        boolean computeAverages;
        short[][] data = new short[grid.offsets.length][];
        boolean bl = computeAverages = averages == null;
        if (computeAverages) {
            averages = new double[data.length];
        }
        for (int dim = 0; dim < data.length; ++dim) {
            double average;
            if (computeAverages) {
                average = Math.rint(grid.getCellMean(dim) / scale);
                averages[dim] = average * scale;
            } else {
                average = averages[dim] / scale;
            }
            float[] offsets = grid.offsets[dim];
            short[] compressed = new short[offsets.length];
            for (int i = 0; i < offsets.length; ++i) {
                double c = DecimalFunctions.floatToDouble(offsets[i]);
                float tolerance = Math.ulp((float)(c /= scale));
                c -= average;
                if (Math.abs(c -= (double)(compressed[i] = (short)Math.round(c))) < (double)tolerance) continue;
                return grid;
            }
            data[dim] = compressed;
        }
        return new DatumShiftGridCompressed<C, T>(grid, averages, data, scale);
    }

    @Override
    protected final DatumShiftGridFile<C, T> setData(Object[] other) {
        return new DatumShiftGridCompressed<C, T>(this, this.averages, (short[][])other, this.scale);
    }

    @Override
    public double getCellPrecision() {
        return Math.min(super.getCellPrecision(), 5.0 * this.scale);
    }

    @Override
    protected final Object[] getData() {
        return this.data;
    }

    @Override
    public final int getTranslationDimensions() {
        return this.data.length;
    }

    @Override
    public double getCellMean(int dim) {
        return this.averages[dim];
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        return (double)this.data[dim][gridX + gridY * this.scanlineStride] * this.scale + this.averages[dim];
    }

    @Override
    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        boolean skipY;
        boolean skipX;
        int xmax = this.getGridSize(0) - 2;
        int ymax = this.getGridSize(1) - 2;
        int ix = (int)gridX;
        int iy = (int)gridY;
        if (ix < 0 || ix > xmax || iy < 0 || iy > ymax) {
            double[] gridCoordinates = new double[]{gridX, gridY};
            this.replaceOutsideGridCoordinates(gridCoordinates);
            gridX = gridCoordinates[0];
            gridY = gridCoordinates[1];
            ix = Math.max(0, Math.min(xmax, (int)gridX));
            iy = Math.max(0, Math.min(ymax, (int)gridY));
        }
        gridY -= (double)iy;
        boolean bl = skipX = (gridX -= (double)ix) < 0.0;
        if (skipX) {
            gridX = 0.0;
        }
        boolean bl2 = skipY = gridY < 0.0;
        if (skipY) {
            gridY = 0.0;
        }
        if (gridX > 1.0) {
            gridX = 1.0;
            skipX = true;
        }
        if (gridY > 1.0) {
            gridY = 1.0;
            skipY = true;
        }
        int p00 = this.scanlineStride * iy + ix;
        int p10 = this.scanlineStride + p00;
        int n = this.data.length;
        boolean derivative = vector.length >= n + 4;
        for (int dim = 0; dim < n; ++dim) {
            short[] values = this.data[dim];
            double r00 = values[p00];
            double r01 = values[p00 + 1];
            double r10 = values[p10];
            double r11 = values[p10 + 1];
            double dx = r01 - r00;
            double r0x = Math.fma(gridX, dx, r00);
            double dy = r11 - r10;
            double r1x = Math.fma(gridX, dy, r10);
            vector[dim] = (gridY * (r1x - r0x) + r0x) * this.scale + this.averages[dim];
            if (!derivative) continue;
            if (skipX) {
                dx = 0.0;
            } else {
                dx += (dy - dx) * gridX;
                dx *= this.scale;
            }
            if (skipY) {
                dy = 0.0;
            } else {
                dy = r10 - r00;
                dy += (r11 - r01 - dy) * gridY;
                dy *= this.scale;
            }
            int i = n;
            if (dim == 0) {
                dx += 1.0;
            } else {
                dy += 1.0;
                i += 2;
                derivative = false;
            }
            vector[i] = dx;
            vector[i + 1] = dy;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            DatumShiftGridCompressed that = (DatumShiftGridCompressed)other;
            return Numerics.equals(this.scale, that.scale) && Arrays.equals(this.averages, that.averages);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.averages);
    }
}

