/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public final class EPSGName {
    private static final String VERSION = null;
    private static final InternationalString REMARKS = null;

    private EPSGName() {
    }

    public static NamedIdentifier create(String code) {
        return new NamedIdentifier(Citations.EPSG, "EPSG", (CharSequence)code, VERSION, REMARKS);
    }

    public static Identifier identifier(int code) {
        return new ImmutableIdentifier(Citations.EPSG, "EPSG", String.valueOf(code).intern(), VERSION, REMARKS);
    }

    public static Map<String, Object> properties(int identifier, String name, String nameOGC) {
        return EPSGName.properties(identifier, name, nameOGC == null ? null : new NamedIdentifier(Citations.OGC, "OGC", (CharSequence)nameOGC, null, null));
    }

    public static Map<String, Object> properties(int identifier, String name, GenericName nameOGC) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("identifiers", EPSGName.identifier(identifier));
        properties.put("name", EPSGName.create(name));
        if (nameOGC != null) {
            properties.put("alias", nameOGC);
        }
        return properties;
    }
}

