/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Map;
import org.apache.sis.internal.jaxb.referencing.CS_CoordinateSystem;
import org.apache.sis.internal.jaxb.referencing.SC_DerivedCRSType;
import org.apache.sis.internal.jaxb.referencing.SC_SingleCRS;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.ExplicitParameters;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ParametricCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.ParametricCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ParametricDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

@XmlType(name="DerivedCRSType", propOrder={"baseCRS", "type", "coordinateSystem"})
@XmlRootElement(name="DerivedCRS")
public class DefaultDerivedCRS
extends AbstractDerivedCRS<Conversion>
implements DerivedCRS {
    private static final long serialVersionUID = -8149602276542469876L;

    protected DefaultDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, Conversion conversion, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, baseCRS, conversion, derivedCS);
    }

    protected DefaultDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
        super(properties, baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
    }

    protected DefaultDerivedCRS(DerivedCRS crs) {
        super((GeneralDerivedCRS)crs);
    }

    public static DefaultDerivedCRS create(Map<String, ?> properties, SingleCRS baseCRS, Conversion conversion, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        String type;
        if (baseCRS != null && derivedCS != null && (type = DefaultDerivedCRS.getType(baseCRS, derivedCS)) != null) {
            switch (type) {
                case "GeodeticCRS": {
                    return new Geodetic(properties, (GeodeticCRS)baseCRS, conversion, derivedCS);
                }
                case "VerticalCRS": {
                    return new Vertical(properties, (VerticalCRS)baseCRS, conversion, (VerticalCS)derivedCS);
                }
                case "TimeCRS": {
                    return new Temporal(properties, (TemporalCRS)baseCRS, conversion, (TimeCS)derivedCS);
                }
                case "ParametricCRS": {
                    return new Parametric(properties, (ParametricCRS)baseCRS, conversion, (ParametricCS)derivedCS);
                }
                case "EngineeringCRS": {
                    if (!(baseCRS instanceof EngineeringCRS)) break;
                    return new Engineering(properties, (EngineeringCRS)baseCRS, conversion, derivedCS);
                }
            }
        }
        return new DefaultDerivedCRS(properties, baseCRS, conversion, derivedCS);
    }

    public static DefaultDerivedCRS create(Map<String, ?> properties, SingleCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
        String type;
        if (baseCRS != null && derivedCS != null && (type = DefaultDerivedCRS.getType(baseCRS, derivedCS)) != null) {
            switch (type) {
                case "GeodeticCRS": {
                    return new Geodetic(properties, (GeodeticCRS)baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
                }
                case "VerticalCRS": {
                    return new Vertical(properties, (VerticalCRS)baseCRS, interpolationCRS, method, baseToDerived, (VerticalCS)derivedCS);
                }
                case "TimeCRS": {
                    return new Temporal(properties, (TemporalCRS)baseCRS, interpolationCRS, method, baseToDerived, (TimeCS)derivedCS);
                }
                case "ParametricCRS": {
                    return new Parametric(properties, (ParametricCRS)baseCRS, interpolationCRS, method, baseToDerived, (ParametricCS)derivedCS);
                }
                case "EngineeringCRS": {
                    if (!(baseCRS instanceof EngineeringCRS)) break;
                    return new Engineering(properties, (EngineeringCRS)baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
                }
            }
        }
        return new DefaultDerivedCRS(properties, baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
    }

    public static DefaultDerivedCRS castOrCopy(DerivedCRS object) {
        if (object == null || object instanceof DefaultDerivedCRS) {
            return (DefaultDerivedCRS)object;
        }
        String type = DefaultDerivedCRS.getType(object.getBaseCRS(), object.getCoordinateSystem());
        if (type != null) {
            switch (type) {
                case "GeodeticCRS": {
                    return new Geodetic(object);
                }
                case "VerticalCRS": {
                    return new Vertical(object);
                }
                case "TimeCRS": {
                    return new Temporal(object);
                }
                case "ParametricCRS": {
                    return new Parametric(object);
                }
                case "EngineeringCRS": {
                    return new Engineering(object);
                }
            }
        }
        return new DefaultDerivedCRS(object);
    }

    @Override
    final Class<Conversion> getConversionType() {
        return Conversion.class;
    }

    @Override
    public Class<? extends DerivedCRS> getInterface() {
        return DerivedCRS.class;
    }

    @Override
    public Datum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    @XmlElement(name="baseCRS", required=true)
    @XmlJavaTypeAdapter(value=SC_SingleCRS.class)
    public SingleCRS getBaseCRS() {
        return (SingleCRS)super.getConversionFromBase().getSourceCRS();
    }

    @Override
    public Conversion getConversionFromBase() {
        return super.getConversionFromBase();
    }

    @Override
    @XmlElement(name="coordinateSystem", required=true)
    @XmlJavaTypeAdapter(value=CS_CoordinateSystem.class)
    public CoordinateSystem getCoordinateSystem() {
        return super.getCoordinateSystem();
    }

    @Override
    public DefaultDerivedCRS forConvention(AxesConvention convention) {
        return (DefaultDerivedCRS)super.forConvention(convention);
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
        Object conversionFromBase = super.getConversionFromBase();
        return new DefaultDerivedCRS(properties, (SingleCRS)conversionFromBase.getSourceCRS(), (Conversion)conversionFromBase, derivedCS);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return super.equals(object, mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1;
        Conversion conversion = this.getConversionFromBase();
        if (conversion == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl = isWKT1 = convention.majorVersion() == 1;
        if (isWKT1) {
            MathTransform inverse = conversion.getMathTransform();
            try {
                inverse = inverse.inverse();
            }
            catch (NoninvertibleTransformException exception) {
                formatter.setInvalidWKT(this, (Exception)((Object)exception));
                inverse = null;
            }
            formatter.newLine();
            formatter.append(inverse);
        }
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)this.getBaseCRS()));
        if (isWKT1) {
            return "Fitted_CS";
        }
        formatter.newLine();
        formatter.append(new ExplicitParameters(this, "DerivingConversion"));
        if (convention == Convention.INTERNAL || !DefaultDerivedCRS.isBaseCRS(formatter)) {
            CoordinateSystem cs = this.getCoordinateSystem();
            this.formatCS(formatter, cs, ReferencingUtilities.getUnit(cs), isWKT1);
        }
        return this.keyword(formatter);
    }

    String keyword(Formatter formatter) {
        String shortKeyword;
        String longKeyword = DefaultDerivedCRS.getType(this.getBaseCRS(), this.getCoordinateSystem());
        if (longKeyword == null) {
            return null;
        }
        switch (longKeyword) {
            case "GeodeticCRS": {
                shortKeyword = "GeodCRS";
                break;
            }
            case "VerticalCRS": {
                shortKeyword = "VertCRS";
                break;
            }
            case "EngineeringCRS": {
                shortKeyword = "EngCRS";
                break;
            }
            default: {
                return longKeyword;
            }
        }
        return formatter.shortOrLong(shortKeyword, longKeyword);
    }

    static String getType(SingleCRS baseCRS, CoordinateSystem derivedCS) {
        Class type;
        if (baseCRS instanceof AbstractIdentifiedObject) {
            type = ((AbstractIdentifiedObject)baseCRS).getInterface();
        } else if (baseCRS != null) {
            type = baseCRS.getClass();
        } else {
            return null;
        }
        if (GeodeticCRS.class.isAssignableFrom(type) && CoordinateSystems.isGeodetic(derivedCS)) {
            return "GeodeticCRS";
        }
        if (VerticalCRS.class.isAssignableFrom(type) && derivedCS instanceof VerticalCS) {
            return "VerticalCRS";
        }
        if (TemporalCRS.class.isAssignableFrom(type) && derivedCS instanceof TimeCS) {
            return "TimeCRS";
        }
        if (ParametricCRS.class.isAssignableFrom(type) && derivedCS instanceof ParametricCS) {
            return "ParametricCRS";
        }
        if (ProjectedCRS.class.isAssignableFrom(type) || EngineeringCRS.class.isAssignableFrom(type)) {
            return "EngineeringCRS";
        }
        return null;
    }

    private DefaultDerivedCRS() {
    }

    @XmlElement(name="derivedCRSType", required=true)
    SC_DerivedCRSType getType() {
        return SC_DerivedCRSType.fromWKT(DefaultDerivedCRS.getType(this.getBaseCRS(), this.getCoordinateSystem()));
    }

    private void setBaseCRS(SingleCRS crs) {
        this.setBaseCRS("baseCRS", crs);
    }

    private void setCoordinateSystem(CoordinateSystem cs) {
        this.setCoordinateSystem("coordinateSystem", cs);
    }

    @XmlTransient
    private static final class Geodetic
    extends DefaultDerivedCRS
    implements GeodeticCRS {
        private static final long serialVersionUID = -1263243517380302846L;

        Geodetic(DerivedCRS other) {
            super(other);
        }

        Geodetic(Map<String, ?> properties, GeodeticCRS baseCRS, Conversion conversion, CoordinateSystem derivedCS) {
            super(properties, (SingleCRS)baseCRS, conversion, derivedCS);
        }

        Geodetic(Map<String, ?> properties, GeodeticCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
            super(properties, (SingleCRS)baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
        }

        public GeodeticDatum getDatum() {
            return (GeodeticDatum)super.getDatum();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
            Conversion conversionFromBase = this.getConversionFromBase();
            return new Geodetic(properties, (GeodeticCRS)conversionFromBase.getSourceCRS(), conversionFromBase, derivedCS);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("GeodCRS", "GeodeticCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("geodetic");
        }
    }

    @XmlTransient
    private static final class Vertical
    extends DefaultDerivedCRS
    implements VerticalCRS {
        private static final long serialVersionUID = -5599709829566076972L;

        Vertical(DerivedCRS other) {
            super(other);
        }

        Vertical(Map<String, ?> properties, VerticalCRS baseCRS, Conversion conversion, VerticalCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, conversion, (CoordinateSystem)derivedCS);
        }

        Vertical(Map<String, ?> properties, VerticalCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, VerticalCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, interpolationCRS, method, baseToDerived, (CoordinateSystem)derivedCS);
        }

        public VerticalDatum getDatum() {
            return (VerticalDatum)super.getDatum();
        }

        public VerticalCS getCoordinateSystem() {
            return (VerticalCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
            Conversion conversionFromBase = this.getConversionFromBase();
            return new Vertical(properties, (VerticalCRS)conversionFromBase.getSourceCRS(), conversionFromBase, (VerticalCS)derivedCS);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("VertCRS", "VerticalCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("vertical");
        }
    }

    @XmlTransient
    private static final class Temporal
    extends DefaultDerivedCRS
    implements TemporalCRS {
        private static final long serialVersionUID = -4721311735720248819L;

        Temporal(DerivedCRS other) {
            super(other);
        }

        Temporal(Map<String, ?> properties, TemporalCRS baseCRS, Conversion conversion, TimeCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, conversion, (CoordinateSystem)derivedCS);
        }

        Temporal(Map<String, ?> properties, TemporalCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, TimeCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, interpolationCRS, method, baseToDerived, (CoordinateSystem)derivedCS);
        }

        public TemporalDatum getDatum() {
            return (TemporalDatum)super.getDatum();
        }

        public TimeCS getCoordinateSystem() {
            return (TimeCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
            Conversion conversionFromBase = this.getConversionFromBase();
            return new Temporal(properties, (TemporalCRS)conversionFromBase.getSourceCRS(), conversionFromBase, (TimeCS)derivedCS);
        }

        @Override
        String keyword(Formatter formatter) {
            return "TimeCRS";
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("time");
        }
    }

    @XmlTransient
    private static final class Parametric
    extends DefaultDerivedCRS
    implements ParametricCRS {
        private static final long serialVersionUID = 2344979923957294024L;

        Parametric(DerivedCRS other) {
            super(other);
        }

        Parametric(Map<String, ?> properties, ParametricCRS baseCRS, Conversion conversion, ParametricCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, conversion, (CoordinateSystem)derivedCS);
        }

        Parametric(Map<String, ?> properties, ParametricCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, ParametricCS derivedCS) {
            super(properties, (SingleCRS)baseCRS, interpolationCRS, method, baseToDerived, (CoordinateSystem)derivedCS);
        }

        public ParametricDatum getDatum() {
            return (ParametricDatum)super.getDatum();
        }

        public ParametricCS getCoordinateSystem() {
            return (ParametricCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
            Conversion conversionFromBase = this.getConversionFromBase();
            return new Parametric(properties, (ParametricCRS)conversionFromBase.getSourceCRS(), conversionFromBase, (ParametricCS)derivedCS);
        }

        @Override
        String keyword(Formatter formatter) {
            return "ParametricCRS";
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("parametric");
        }
    }

    @XmlTransient
    private static final class Engineering
    extends DefaultDerivedCRS
    implements EngineeringCRS {
        private static final long serialVersionUID = 42334975023270039L;

        Engineering(DerivedCRS other) {
            super(other);
        }

        Engineering(Map<String, ?> properties, EngineeringCRS baseCRS, Conversion conversion, CoordinateSystem derivedCS) {
            super(properties, (SingleCRS)baseCRS, conversion, derivedCS);
        }

        Engineering(Map<String, ?> properties, EngineeringCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) {
            super(properties, (SingleCRS)baseCRS, interpolationCRS, method, baseToDerived, derivedCS);
        }

        public EngineeringDatum getDatum() {
            return (EngineeringDatum)super.getDatum();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem derivedCS) {
            Conversion conversionFromBase = this.getConversionFromBase();
            return new Engineering(properties, (EngineeringCRS)conversionFromBase.getSourceCRS(), conversionFromBase, derivedCS);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("EngCRS", "EngineeringCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("engineering");
        }
    }
}

