/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class TransverseMercator
extends NormalizedProjection {
    private static final long serialVersionUID = -627685138188387835L;
    private static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    private final double cf2;
    private final double cf4;
    private final double cf6;
    private final double cf8;
    private final double ci2;
    private final double ci4;
    private final double ci6;
    private final double ci8;

    private static boolean identityEquals(double actual, double expected) {
        return !(Math.abs(actual - expected) > 1.5706706731410455E-12 * Math.max(1.0, Math.abs(expected)));
    }

    public TransverseMercator(OperationMethod method, Parameters parameters) {
        this(TransverseMercator.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)TransverseMercator.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), null);
        EnumMap<NormalizedProjection.ParameterRole, Object> roles = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        NormalizedProjection.ParameterRole xOffset = NormalizedProjection.ParameterRole.FALSE_EASTING;
        NormalizedProjection.ParameterRole yOffset = NormalizedProjection.ParameterRole.FALSE_NORTHING;
        if (variant == Variant.SOUTH_ORIENTATED) {
            xOffset = NormalizedProjection.ParameterRole.FALSE_WESTING;
            yOffset = NormalizedProjection.ParameterRole.FALSE_SOUTHING;
        }
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.TransverseMercator.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.TransverseMercator.SCALE_FACTOR);
        roles.put(xOffset, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_EASTING);
        roles.put(yOffset, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, variant);
    }

    TransverseMercator(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.TransverseMercator.LATITUDE_OF_ORIGIN));
        DoubleDouble nd = initializer.axisLengthRatio().ratio_1m_1p();
        double n = nd.doubleValue();
        double n2 = n * n;
        double n3 = n2 * n;
        double n4 = n2 * n2;
        this.cf2 = 0.22777777777777777 * n4 + 0.3125 * n3 + -0.6666666666666666 * n2 + n / 2.0;
        double cf4 = 0.38680555555555557 * n4 + -0.6 * n3 + 0.2708333333333333 * n2;
        double cf6 = -0.7357142857142858 * n4 + 0.25416666666666665 * n3;
        double cf8 = 0.30729786706349205 * n4;
        this.ci2 = -0.002777777777777778 * n4 + 0.3854166666666667 * n3 + -0.6666666666666666 * n2 + n / 2.0;
        double ci4 = -0.3034722222222222 * n4 + 0.06666666666666667 * n3 + 0.020833333333333332 * n2;
        double ci6 = -0.04404761904761905 * n4 + 0.035416666666666666 * n3;
        double ci8 = 0.02726314484126984 * n4;
        DoubleDouble B = nd.square().series(1.0, 0.25, 0.015625).divide(nd.add(1));
        double Q = MathFunctions.asinh(Math.tan(\u03c60)) - this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.sin(\u03c60));
        double \u03b2 = Math.atan(Math.sinh(Q));
        DoubleDouble M0 = B.negate().multiply(\u03b2 + Math.fma(this.cf2, Math.sin(2.0 * \u03b2), Math.fma(cf4, Math.sin(4.0 * \u03b2), Math.fma(cf6, Math.sin(6.0 * \u03b2), cf8 * Math.sin(8.0 * \u03b2)))), false);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, B, null);
        denormalize.convertBefore(1, B, M0);
        ci4 *= 4.0;
        ci6 *= 16.0;
        ci8 *= 64.0;
        this.cf4 = cf4 *= 4.0;
        this.cf6 = cf6 *= 16.0;
        this.cf8 = cf8 *= 64.0;
        this.ci4 = ci4;
        this.ci6 = ci6;
        this.ci8 = ci8;
    }

    TransverseMercator(TransverseMercator other) {
        super(null, other);
        this.cf2 = other.cf2;
        this.cf4 = other.cf4;
        this.cf6 = other.cf6;
        this.cf8 = other.cf8;
        this.ci2 = other.ci2;
        this.ci4 = other.ci4;
        this.ci6 = other.ci6;
        this.ci8 = other.ci8;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        TransverseMercator kernel = this;
        if (this.eccentricity == 0.0 && this.getClass() == TransverseMercator.class) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        Envelope2D domain = new Envelope2D();
        domain.x = -0.6981317007977318;
        domain.y = -1.4660765716752369;
        domain.width = -2.0 * domain.x;
        domain.height = -2.0 * domain.y;
        return Optional.of(domain);
    }

    private static Matrix outsideDomainOfValidity(double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            dstPts[dstOff + 1] = Double.NaN;
            dstPts[dstOff] = Double.NaN;
        }
        if (derivate) {
            return new Matrix2(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        return null;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        if (Math.abs(\u03bb) > 1.5707963267948966 && Math.abs(Math.IEEEremainder(\u03bb, Math.PI * 2)) > 1.5707963267948966) {
            return TransverseMercator.outsideDomainOfValidity(dstPts, dstOff, derivate);
        }
        double sin\u03bb = Math.sin(\u03bb);
        double \u212fsin\u03c6 = Math.sin(\u03c6) * this.eccentricity;
        double Q = MathFunctions.asinh(Math.tan(\u03c6)) - MathFunctions.atanh(\u212fsin\u03c6) * this.eccentricity;
        double coshQ = Math.cosh(Q);
        double \u03b70 = MathFunctions.atanh(sin\u03bb / coshQ);
        double cosh\u03b70 = Math.cosh(\u03b70);
        double \u03be0 = Math.asin(Math.tanh(Q) * cosh\u03b70);
        double sin_2\u03be0 = Math.sin(2.0 * \u03be0);
        double cos_2\u03be0 = Math.cos(2.0 * \u03be0);
        double sin2 = sin_2\u03be0 * sin_2\u03be0;
        double cos2 = cos_2\u03be0 * cos_2\u03be0;
        double sin_4\u03be0 = sin_2\u03be0 * cos_2\u03be0;
        assert (TransverseMercator.identityEquals(sin_4\u03be0, Math.sin(4.0 * \u03be0) / 2.0)) : \u03be0;
        double cos_4\u03be0 = (cos2 - sin2) * 0.5;
        assert (TransverseMercator.identityEquals(cos_4\u03be0, Math.cos(4.0 * \u03be0) / 2.0)) : \u03be0;
        double sin_6\u03be0 = (0.75 - sin2) * sin_2\u03be0;
        assert (TransverseMercator.identityEquals(sin_6\u03be0, Math.sin(6.0 * \u03be0) / 4.0)) : \u03be0;
        double cos_6\u03be0 = (cos2 - 0.75) * cos_2\u03be0;
        assert (TransverseMercator.identityEquals(cos_6\u03be0, Math.cos(6.0 * \u03be0) / 4.0)) : \u03be0;
        double sin_8\u03be0 = sin_4\u03be0 * cos_4\u03be0;
        assert (TransverseMercator.identityEquals(sin_8\u03be0, Math.sin(8.0 * \u03be0) / 8.0)) : \u03be0;
        double cos_8\u03be0 = 0.125 - sin_4\u03be0 * sin_4\u03be0;
        assert (TransverseMercator.identityEquals(cos_8\u03be0, Math.cos(8.0 * \u03be0) / 8.0)) : \u03be0;
        double sinh_2\u03b70 = Math.sinh(2.0 * \u03b70);
        double cosh_2\u03b70 = Math.cosh(2.0 * \u03b70);
        double sinh2 = sinh_2\u03b70 * sinh_2\u03b70;
        double cosh2 = cosh_2\u03b70 * cosh_2\u03b70;
        double cosh_4\u03b70 = (cosh2 + sinh2) * 0.5;
        assert (TransverseMercator.identityEquals(cosh_4\u03b70, Math.cosh(4.0 * \u03b70) / 2.0)) : \u03b70;
        double sinh_4\u03b70 = cosh_2\u03b70 * sinh_2\u03b70;
        assert (TransverseMercator.identityEquals(sinh_4\u03b70, Math.sinh(4.0 * \u03b70) / 2.0)) : \u03b70;
        double cosh_6\u03b70 = cosh_2\u03b70 * (cosh2 - 0.75);
        assert (TransverseMercator.identityEquals(cosh_6\u03b70, Math.cosh(6.0 * \u03b70) / 4.0)) : \u03b70;
        double sinh_6\u03b70 = sinh_2\u03b70 * (sinh2 + 0.75);
        assert (TransverseMercator.identityEquals(sinh_6\u03b70, Math.sinh(6.0 * \u03b70) / 4.0)) : \u03b70;
        double cosh_8\u03b70 = sinh_4\u03b70 * sinh_4\u03b70 + 0.125;
        assert (TransverseMercator.identityEquals(cosh_8\u03b70, Math.cosh(8.0 * \u03b70) / 8.0)) : \u03b70;
        double sinh_8\u03b70 = sinh_4\u03b70 * cosh_4\u03b70;
        assert (TransverseMercator.identityEquals(sinh_8\u03b70, Math.sinh(8.0 * \u03b70) / 8.0)) : \u03b70;
        if (dstPts != null) {
            dstPts[dstOff] = this.cf8 * cos_8\u03be0 * sinh_8\u03b70 + this.cf6 * cos_6\u03be0 * sinh_6\u03b70 + this.cf4 * cos_4\u03be0 * sinh_4\u03b70 + this.cf2 * cos_2\u03be0 * sinh_2\u03b70 + \u03b70;
            dstPts[dstOff + 1] = this.cf8 * sin_8\u03be0 * cosh_8\u03b70 + this.cf6 * sin_6\u03be0 * cosh_6\u03b70 + this.cf4 * sin_4\u03be0 * cosh_4\u03b70 + this.cf2 * sin_2\u03be0 * cosh_2\u03b70 + \u03be0;
        }
        if (!derivate) {
            return null;
        }
        double cos\u03bb = Math.cos(\u03bb);
        double cos\u03c6 = Math.cos(\u03c6);
        double cosh2Q = coshQ * coshQ;
        double sinhQ = Math.sinh(Q);
        double tanhQ = Math.tanh(Q);
        double cosh2Q_sin2\u03bb = cosh2Q - sin\u03bb * sin\u03bb;
        double sinh\u03b70 = Math.sinh(\u03b70);
        double sqrt1_thQch\u03b70 = Math.sqrt(1.0 - tanhQ * tanhQ * (cosh\u03b70 * cosh\u03b70));
        double dQ_d\u03c6 = 1.0 / cos\u03c6 - this.eccentricitySquared * cos\u03c6 / (1.0 - \u212fsin\u03c6 * \u212fsin\u03c6);
        double d\u03b70_d\u03bb = cos\u03bb * coshQ / cosh2Q_sin2\u03bb;
        double d\u03b70_d\u03c6 = -dQ_d\u03c6 * sin\u03bb * sinhQ / cosh2Q_sin2\u03bb;
        double d\u03be0_d\u03bb = sinhQ * sinh\u03b70 * cos\u03bb / (cosh2Q_sin2\u03bb * sqrt1_thQch\u03b70);
        double d\u03be0_d\u03c6 = (dQ_d\u03c6 * cosh\u03b70 / cosh2Q + d\u03b70_d\u03c6 * sinh\u03b70 * tanhQ) / sqrt1_thQch\u03b70;
        double d\u03be_d\u03bb = d\u03be0_d\u03bb + 2.0 * (this.cf2 * (d\u03be0_d\u03bb * cos_2\u03be0 * cosh_2\u03b70 + d\u03b70_d\u03bb * sinh_2\u03b70 * sin_2\u03be0) + 3.0 * this.cf6 * (d\u03be0_d\u03bb * cos_6\u03be0 * cosh_6\u03b70 + d\u03b70_d\u03bb * sinh_6\u03b70 * sin_6\u03be0) + 2.0 * (this.cf4 * (d\u03be0_d\u03bb * cos_4\u03be0 * cosh_4\u03b70 + d\u03b70_d\u03bb * sinh_4\u03b70 * sin_4\u03be0) + 2.0 * this.cf8 * (d\u03be0_d\u03bb * cos_8\u03be0 * cosh_8\u03b70 + d\u03b70_d\u03bb * sinh_8\u03b70 * sin_8\u03be0)));
        double d\u03be_d\u03c6 = d\u03be0_d\u03c6 + 2.0 * (this.cf2 * (d\u03be0_d\u03c6 * cos_2\u03be0 * cosh_2\u03b70 + d\u03b70_d\u03c6 * sinh_2\u03b70 * sin_2\u03be0) + 3.0 * this.cf6 * (d\u03be0_d\u03c6 * cos_6\u03be0 * cosh_6\u03b70 + d\u03b70_d\u03c6 * sinh_6\u03b70 * sin_6\u03be0) + 2.0 * (this.cf4 * (d\u03be0_d\u03c6 * cos_4\u03be0 * cosh_4\u03b70 + d\u03b70_d\u03c6 * sinh_4\u03b70 * sin_4\u03be0) + 2.0 * this.cf8 * (d\u03be0_d\u03c6 * cos_8\u03be0 * cosh_8\u03b70 + d\u03b70_d\u03c6 * sinh_8\u03b70 * sin_8\u03be0)));
        double d\u03b7_d\u03bb = d\u03b70_d\u03bb + 2.0 * (this.cf2 * (d\u03b70_d\u03bb * cosh_2\u03b70 * cos_2\u03be0 - d\u03be0_d\u03bb * sin_2\u03be0 * sinh_2\u03b70) + 3.0 * this.cf6 * (d\u03b70_d\u03bb * cosh_6\u03b70 * cos_6\u03be0 - d\u03be0_d\u03bb * sin_6\u03be0 * sinh_6\u03b70) + 2.0 * (this.cf4 * (d\u03b70_d\u03bb * cosh_4\u03b70 * cos_4\u03be0 - d\u03be0_d\u03bb * sin_4\u03be0 * sinh_4\u03b70) + 2.0 * this.cf8 * (d\u03b70_d\u03bb * cosh_8\u03b70 * cos_8\u03be0 - d\u03be0_d\u03bb * sin_8\u03be0 * sinh_8\u03b70)));
        double d\u03b7_d\u03c6 = d\u03b70_d\u03c6 + 2.0 * (this.cf2 * (d\u03b70_d\u03c6 * cosh_2\u03b70 * cos_2\u03be0 - d\u03be0_d\u03c6 * sin_2\u03be0 * sinh_2\u03b70) + 3.0 * this.cf6 * (d\u03b70_d\u03c6 * cosh_6\u03b70 * cos_6\u03be0 - d\u03be0_d\u03c6 * sin_6\u03be0 * sinh_6\u03b70) + 2.0 * (this.cf4 * (d\u03b70_d\u03c6 * cosh_4\u03b70 * cos_4\u03be0 - d\u03be0_d\u03c6 * sin_4\u03be0 * sinh_4\u03b70) + 2.0 * this.cf8 * (d\u03b70_d\u03c6 * cosh_8\u03b70 * cos_8\u03be0 - d\u03be0_d\u03c6 * sin_8\u03be0 * sinh_8\u03b70)));
        return new Matrix2(d\u03b7_d\u03bb, d\u03b7_d\u03c6, d\u03be_d\u03bb, d\u03be_d\u03c6);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double \u03b7 = srcPts[srcOff];
        double \u03be = srcPts[srcOff + 1];
        double sin_2\u03be = Math.sin(2.0 * \u03be);
        double cos_2\u03be = Math.cos(2.0 * \u03be);
        double sinh_2\u03b7 = Math.sinh(2.0 * \u03b7);
        double cosh_2\u03b7 = Math.cosh(2.0 * \u03b7);
        double sin2 = sin_2\u03be * sin_2\u03be;
        double cos2 = cos_2\u03be * cos_2\u03be;
        double sin_4\u03be = sin_2\u03be * cos_2\u03be;
        assert (TransverseMercator.identityEquals(sin_4\u03be, Math.sin(4.0 * \u03be) / 2.0)) : \u03be;
        double cos_4\u03be = (cos2 - sin2) * 0.5;
        assert (TransverseMercator.identityEquals(cos_4\u03be, Math.cos(4.0 * \u03be) / 2.0)) : \u03be;
        double sin_6\u03be = (0.75 - sin2) * sin_2\u03be;
        assert (TransverseMercator.identityEquals(sin_6\u03be, Math.sin(6.0 * \u03be) / 4.0)) : \u03be;
        double cos_6\u03be = (cos2 - 0.75) * cos_2\u03be;
        assert (TransverseMercator.identityEquals(cos_6\u03be, Math.cos(6.0 * \u03be) / 4.0)) : \u03be;
        double sin_8\u03be = sin_4\u03be * cos_4\u03be;
        assert (TransverseMercator.identityEquals(sin_8\u03be, Math.sin(8.0 * \u03be) / 8.0)) : \u03be;
        double cos_8\u03be = 0.125 - sin_4\u03be * sin_4\u03be;
        assert (TransverseMercator.identityEquals(cos_8\u03be, Math.cos(8.0 * \u03be) / 8.0)) : \u03be;
        double sinh2 = sinh_2\u03b7 * sinh_2\u03b7;
        double cosh2 = cosh_2\u03b7 * cosh_2\u03b7;
        double cosh_4\u03b7 = (cosh2 + sinh2) * 0.5;
        assert (TransverseMercator.identityEquals(cosh_4\u03b7, Math.cosh(4.0 * \u03b7) / 2.0)) : \u03b7;
        double sinh_4\u03b7 = cosh_2\u03b7 * sinh_2\u03b7;
        assert (TransverseMercator.identityEquals(sinh_4\u03b7, Math.sinh(4.0 * \u03b7) / 2.0)) : \u03b7;
        double cosh_6\u03b7 = cosh_2\u03b7 * (cosh2 - 0.75);
        assert (TransverseMercator.identityEquals(cosh_6\u03b7, Math.cosh(6.0 * \u03b7) / 4.0)) : \u03b7;
        double sinh_6\u03b7 = sinh_2\u03b7 * (sinh2 + 0.75);
        assert (TransverseMercator.identityEquals(sinh_6\u03b7, Math.sinh(6.0 * \u03b7) / 4.0)) : \u03b7;
        double cosh_8\u03b7 = sinh_4\u03b7 * sinh_4\u03b7 + 0.125;
        assert (TransverseMercator.identityEquals(cosh_8\u03b7, Math.cosh(8.0 * \u03b7) / 8.0)) : \u03b7;
        double sinh_8\u03b7 = sinh_4\u03b7 * cosh_4\u03b7;
        assert (TransverseMercator.identityEquals(sinh_8\u03b7, Math.sinh(8.0 * \u03b7) / 8.0)) : \u03b7;
        double \u03be0 = \u03be - (this.ci8 * sin_8\u03be * cosh_8\u03b7 + this.ci6 * sin_6\u03be * cosh_6\u03b7 + this.ci4 * sin_4\u03be * cosh_4\u03b7 + this.ci2 * sin_2\u03be * cosh_2\u03b7);
        double \u03b70 = \u03b7 - (this.ci8 * cos_8\u03be * sinh_8\u03b7 + this.ci6 * cos_6\u03be * sinh_6\u03b7 + this.ci4 * cos_4\u03be * sinh_4\u03b7 + this.ci2 * cos_2\u03be * sinh_2\u03b7);
        double \u03b2 = Math.asin(Math.sin(\u03be0) / Math.cosh(\u03b70));
        double Q = MathFunctions.asinh(Math.tan(\u03b2));
        double p = this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.tanh(Q));
        double Qp = Q + p;
        for (int it = 0; it < 18; ++it) {
            double c = this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.tanh(Qp));
            Qp = Q + c;
            if (Math.abs(c - p) <= 3.926676682852614E-10) {
                dstPts[dstOff] = Math.asin(Math.tanh(\u03b70) / Math.cos(\u03b2));
                dstPts[dstOff + 1] = Math.atan(Math.sinh(Qp));
                return;
            }
            p = c;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    private static enum Variant implements ProjectionVariant
    {
        SOUTH_ORIENTATED(".*\\bSouth\\b.*", "9808");

        private final Pattern operationName;
        private final String identifier;

        private Variant(String operationName, String identifier) {
            this.operationName = Pattern.compile(operationName, 2);
            this.identifier = identifier;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    private static final class Spherical
    extends TransverseMercator {
        private static final long serialVersionUID = 8903592710452235162L;

        protected Spherical(TransverseMercator other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            if (cos\u03bb < 0.0) {
                return TransverseMercator.outsideDomainOfValidity(dstPts, dstOff, derivate);
            }
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double tan\u03c6 = sin\u03c6 / cos\u03c6;
            double B = cos\u03c6 * sin\u03bb;
            if (dstPts != null) {
                dstPts[dstOff] = MathFunctions.atanh(B);
                dstPts[dstOff + 1] = Math.atan2(tan\u03c6, cos\u03bb);
            }
            if (!derivate) {
                return null;
            }
            double Bm = B * B - 1.0;
            double sct = cos\u03bb * cos\u03bb + tan\u03c6 * tan\u03c6;
            return new Matrix2(-(cos\u03c6 * cos\u03bb) / Bm, sin\u03c6 * sin\u03bb / Bm, tan\u03c6 * sin\u03bb / sct, cos\u03bb / (cos\u03c6 * cos\u03c6 * sct));
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double sinhx = Math.sinh(x);
            double cosy = Math.cos(y);
            dstPts[dstOff] = Math.atan2(sinhx, cosy);
            dstPts[dstOff + 1] = Math.copySign(Math.asin(Math.sqrt((1.0 - cosy * cosy) / (1.0 + sinhx * sinhx))), y);
        }
    }
}

