/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.TestRunArg;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.log4testng.Logger;

public class SchematronTests
extends DataFixture {
    private SchematronValidator dataValidator;

    @BeforeClass
    public void createSchematronValidator(ITestContext testContext) {
        Map<String, String> piData = this.getXmlModelPIData(this.dataFile);
        String phase = "#ALL";
        StreamSource schema = null;
        if (this.isSchematronReference(piData)) {
            URI schematronURI = URI.create(piData.get("href"));
            if (!schematronURI.isAbsolute()) {
                String dataURI = testContext.getSuite().getParameter(TestRunArg.GML.toString());
                URI baseURI = URI.create(dataURI);
                schematronURI = baseURI.resolve(schematronURI);
            }
            schema = new StreamSource(schematronURI.toString());
            if (piData.containsKey("phase")) {
                phase = piData.get("phase");
            }
        } else {
            Set suiteAttrs = testContext.getSuite().getAttributeNames();
            if (suiteAttrs.contains(SuiteAttribute.SCHEMATRON.getName())) {
                URI schematronURI = (URI)testContext.getSuite().getAttribute(SuiteAttribute.SCHEMATRON.getName());
                schema = new StreamSource(schematronURI.toString());
            }
        }
        if (null != schema) {
            try {
                this.dataValidator = new SchematronValidator((Source)schema, phase);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)"Failed to create SchematronValidator.\n", (Throwable)e);
            }
        }
    }

    @Test(description="Checks general Schematron rules specified in ISO 19136")
    public void checkGMLSchematronConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/iso19136/sch/gml-3.2.1.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    @Test(description="See ISO 19136: Annex I")
    public void checkForDeprecatedGMLElements() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/iso19136/sch/gml-deprecated-3.2.1.sch");
        ETSAssert.assertSchematronValid(schRef, new StreamSource(this.dataFile));
    }

    @Test(description="Checks application-specific Schematron rules")
    public void checkSchematronConstraints() {
        if (null == this.dataValidator) {
            throw new SkipException("Schematron schema reference not found.");
        }
        StreamSource gmlSource = new StreamSource(this.dataFile);
        Result result = this.dataValidator.validate((Source)gmlSource);
        Assert.assertFalse((boolean)this.dataValidator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", this.dataValidator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    boolean isSchematronReference(Map<String, String> piData) {
        if (null != piData && null != piData.get("schematypens")) {
            return piData.get("schematypens").equals("http://purl.oclc.org/dsdl/schematron");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getXmlModelPIData(File dataFile) {
        HashMap<String, String> piData = null;
        XMLStreamReader reader = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(dataFile);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader(input);
            int event = reader.getEventType();
            while (event != 1) {
                event = reader.next();
                if (event != 3 || !reader.getPITarget().equals("xml-model")) continue;
                String[] pseudoAttrs = reader.getPIData().split("\\s+");
                piData = new HashMap<String, String>();
                for (String pseudoAttr : pseudoAttrs) {
                    String[] nv = pseudoAttr.split("=");
                    piData.put(nv[0].trim(), nv[1].replace('\"', ' ').trim());
                }
                break;
            }
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse document at " + dataFile.getAbsolutePath(), e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception x) {
                TestSuiteLogger.log(Level.INFO, x.getMessage());
            }
        }
        return piData;
    }
}

