/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PointTests
extends DataFixture {
    NodeList points;
    List<QName> pointElems = new ArrayList<QName>();

    @BeforeClass
    public void findPoints() {
        StreamSource data = new StreamSource(this.dataFile);
        this.pointElems.add(new QName("http://www.opengis.net/gml/3.2", "Point"));
        if (null != this.model) {
            XSElementDeclaration gmlPoint = this.model.getElementDeclaration("Point", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> pointDecls = XMLSchemaModelUtils.getElementsByAffiliation(this.model, gmlPoint);
            for (XSElementDeclaration decl : pointDecls) {
                this.pointElems.add(new QName(decl.getNamespace(), decl.getName()));
            }
        }
        HashMap<String, String> namespaceBindings = new HashMap<String, String>();
        String xpath = this.generateXPathExpression(this.pointElems, namespaceBindings);
        try {
            this.points = (NodeList)XMLUtils.evaluateXPath(data, xpath, namespaceBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        Assert.assertFalse((this.points.getLength() == 0 ? 1 : 0) != 0, (String)"gml:Point elements not found.");
    }

    @Test(description="See ISO 19136: 9.10, 10.1.3.2; ISO 19107: 6.2.2.17")
    public void pointHasValidCRS() {
        for (int i = 0; i < this.points.getLength(); ++i) {
            Element point = (Element)this.points.item(i);
            GeometryAssert.assertValidCRS(point);
        }
    }

    @Test(description="See ISO 19107: 6.2.2.10")
    public void pointHasValidPosition() {
        for (int i = 0; i < this.points.getLength(); ++i) {
            Element point = (Element)this.points.item(i);
            DirectPosition dpos = null;
            boolean ignoreThirdDimension = true;
            try {
                dpos = this.createDirectPosition(point, ignoreThirdDimension);
            }
            catch (IndexOutOfBoundsException x) {
                throw new AssertionError((Object)ErrorMessage.format("CoordinateDimensionErr", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), GmlUtils.findCRSReference((Element)point)));
            }
            Assert.assertEquals((int)dpos.getDimension(), (int)dpos.getCoordinateReferenceSystem().getCoordinateSystem().getDimension(), (String)ErrorMessage.format("CoordinateDimensionErr", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), GmlUtils.findCRSReference((Element)point)));
            ImmutableEnvelope validArea = new ImmutableEnvelope(CRS.getDomainOfValidity((CoordinateReferenceSystem)dpos.getCoordinateReferenceSystem()));
            Assert.assertTrue((boolean)validArea.contains(dpos), (String)String.format("%s[@gml:id='%s'] is not within CRS area of use: %s.", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), validArea.toString()));
        }
    }

    DirectPosition createDirectPosition(Element point, boolean ignoreThirdDimension) {
        NodeList posList = point.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "pos");
        if (posList.getLength() != 1) {
            throw new IllegalArgumentException("Expected point geometry containing exactly 1 gml:pos element; received " + point.getNodeName());
        }
        String srsName = GmlUtils.findCRSReference((Element)point);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier((String)srsName));
            if (ignoreThirdDimension) {
                crs = CRS.getHorizontalComponent((CoordinateReferenceSystem)crs);
            }
        }
        catch (FactoryException fex) {
            TestSuiteLogger.log(Level.WARNING, String.format("Unknown srsName found in %s[@gml:id='%s']: %s", point.getLocalName(), point.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), srsName), (Exception)((Object)fex));
        }
        GeneralDirectPosition dpos = new GeneralDirectPosition(crs);
        Element posElem = (Element)posList.item(0);
        String[] coordTuple = posElem.getTextContent().trim().split("\\s+");
        int coordTupleLength = ignoreThirdDimension ? 2 : coordTuple.length;
        for (int i = 0; i < coordTupleLength; ++i) {
            double val = Double.parseDouble(coordTuple[i]);
            dpos.setOrdinate(i, val);
        }
        return dpos;
    }
}

