/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.metadata.distribution.Format;

public abstract class DocumentedStoreProvider
extends URIDataStore.Provider {
    private final String name;
    private transient Format format;

    protected DocumentedStoreProvider(String name) {
        this.name = name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public final Format getFormat() {
        return this.getFormat(null);
    }

    public final synchronized Format getFormat(StoreListeners listeners) {
        if (this.format == null) {
            if (this.name != null) {
                try {
                    this.format = (Format)MetadataSource.getProvided().lookup(Format.class, this.name);
                    return this.format;
                }
                catch (MetadataStoreException e) {
                    LogRecord record = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)39, this.getShortName(), e.getLocalizedMessage());
                    record.setSourceClassName(this.getClass().getCanonicalName());
                    record.setSourceMethodName("getFormat");
                    record.setLoggerName("org.apache.sis.storage");
                    if (listeners != null) {
                        listeners.warning(record);
                    }
                    this.getLogger().log(record);
                }
            }
            this.format = super.getFormat();
        }
        return this.format;
    }
}

