/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public class FeatureNaming<E> {
    private final Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    private final Map<String, E> values = new HashMap<String, E>();

    private static CharSequence name(DataStore store) {
        String name;
        if (store != null && (name = store.getDisplayName()) != null) {
            return name;
        }
        return Vocabulary.formatInternational((short)208);
    }

    private static Locale locale(DataStore store) {
        return store != null ? store.getLocale() : null;
    }

    public E get(DataStore store, String name) throws IllegalNameException {
        Object[] params;
        short key;
        E value = this.values.get(name);
        if (value != null) {
            return value;
        }
        List<String> nc = this.aliases.get(name);
        if (nc == null) {
            key = 17;
            params = new CharSequence[]{FeatureNaming.name(store), name};
        } else if (nc.size() >= 2) {
            key = 15;
            params = new CharSequence[]{FeatureNaming.name(store), nc.get(0), nc.get(1), name};
        } else {
            return null;
        }
        throw new IllegalNameException(FeatureNaming.locale(store), key, params);
    }

    public void add(DataStore store, GenericName name, E value) throws IllegalNameException {
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("value", value);
        String key = name.toString();
        E previous = this.values.put(key, value);
        if (previous != null) {
            List<String> fullNames = this.aliases.get(key);
            if (fullNames == null || fullNames.contains(key)) {
                if (this.values.put(key, previous) != value) {
                    throw new ConcurrentModificationException(FeatureNaming.name(store).toString());
                }
                throw new IllegalNameException(FeatureNaming.locale(store), 16, FeatureNaming.name(store), key);
            }
            CollectionsExt.addToMultiValuesMap(this.aliases, key, key);
        }
        while (name instanceof ScopedName) {
            String alias = (name = ((ScopedName)name).tail()).toString();
            List<String> fullNames = CollectionsExt.addToMultiValuesMap(this.aliases, alias, key);
            if (fullNames.size() > 1) {
                if (fullNames.contains(alias)) continue;
                this.values.remove(alias);
                continue;
            }
            if (this.values.putIfAbsent(alias, value) == null) continue;
            assert (!fullNames.contains(alias)) : alias;
            CollectionsExt.addToMultiValuesMap(this.aliases, alias, alias);
        }
    }

    public boolean remove(DataStore store, GenericName name) throws IllegalNameException {
        ArgumentChecks.ensureNonNull("name", name);
        String key = name.toString();
        if (this.values.remove(key) == null) {
            return false;
        }
        List<String> remaining = CollectionsExt.removeFromMultiValuesMap(this.aliases, key, key);
        if (remaining != null && remaining.size() == 1) {
            String select = remaining.get(0);
            assert (!select.equals(key)) : select;
            if (this.values.put(key, this.values.get(select)) != null) {
                throw new ConcurrentModificationException(FeatureNaming.name(store).toString());
            }
        }
        boolean error = false;
        while (name instanceof ScopedName) {
            String alias = (name = ((ScopedName)name).tail()).toString();
            remaining = CollectionsExt.removeFromMultiValuesMap(this.aliases, alias, key);
            error |= remaining == null;
            if (remaining == null || remaining.isEmpty()) {
                error |= this.values.remove(alias) == null;
                continue;
            }
            if (remaining.size() != 1) continue;
            String select = remaining.get(0);
            assert (!select.equals(key)) : select;
            error |= this.values.putIfAbsent(alias, this.values.get(select)) != null;
        }
        if (error) {
            throw new IllegalNameException(FeatureNaming.locale(store), 10, FeatureNaming.name(store), key);
        }
        return true;
    }
}

