/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.NamedBase;
import org.glassfish.pfl.tf.timer.spi.Statistics;
import org.glassfish.pfl.tf.timer.spi.StatisticsAccumulator;
import org.glassfish.pfl.tf.timer.spi.StatsEventHandler;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEvent;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public abstract class StatsEventHandlerBase
extends NamedBase
implements StatsEventHandler {
    protected static final String UNITS = "nanoseconds";
    protected ArrayList<StatisticsAccumulator> saList;

    protected StatsEventHandlerBase(TimerFactory factory, String name) {
        super(factory, name);
        int size = factory.numberOfIds();
        this.saList = new ArrayList(size);
        for (int ctr = 0; ctr < size; ++ctr) {
            this.saList.add(new StatisticsAccumulator(UNITS));
        }
    }

    @Override
    public void clear() {
        for (StatisticsAccumulator sa : this.saList) {
            sa.clearState();
        }
    }

    protected abstract void recordDuration(int var1, long var2);

    protected final void notify(Stack<TimerEvent> teStack, TimerEvent event) {
        Timer timer = event.timer();
        int id = timer.id();
        if (event.type() == TimerEvent.TimerEventType.ENTER) {
            teStack.push(event);
        } else {
            if (teStack.empty()) {
                throw new IllegalStateException("Unexpected empty stack for EXIT event on timer " + String.valueOf(timer));
            }
            TimerEvent enter = teStack.pop();
            if (!timer.equals(enter.timer())) {
                throw new IllegalStateException("Expected timer " + String.valueOf(timer) + " but found timer " + String.valueOf(enter.timer()) + " on the TimerEvent stack");
            }
            long duration = event.time() - enter.time();
            for (TimerEvent ev : teStack) {
                ev.incrementTime(duration);
            }
            this.recordDuration(id, duration);
        }
    }

    @Override
    public Map<Timer, Statistics> stats() {
        HashMap<Timer, Statistics> result = new HashMap<Timer, Statistics>();
        for (int ctr = 0; ctr < this.saList.size(); ++ctr) {
            Controllable con = this.factory().getControllable(ctr);
            if (!(con instanceof Timer)) continue;
            Timer timer = (Timer)Timer.class.cast(con);
            StatisticsAccumulator sa = this.saList.get(ctr);
            result.put(timer, sa.getStats());
        }
        return result;
    }
}

