/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.MultiValuedPropertyException;

final class MultiValuedAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = 5089428248556035466L;
    private CheckedArrayList<Feature> values;

    public MultiValuedAssociation(FeatureAssociationRole role) {
        super(role);
        this.values = new CheckedArrayList<Feature>(Feature.class);
    }

    MultiValuedAssociation(FeatureAssociationRole role, Object values) {
        super(role);
        this.values = values == null ? new CheckedArrayList<Feature>(Feature.class) : CheckedArrayList.castOrCopy((CheckedArrayList)values, Feature.class);
    }

    @Override
    public Feature getValue() {
        switch (this.values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Feature)this.values.get(0);
            }
        }
        throw new MultiValuedPropertyException(Resources.format((short)53, this.getName()));
    }

    @Override
    public Collection<Feature> getValues() {
        return this.values;
    }

    @Override
    public void setValue(Feature value) {
        this.values.clear();
        if (value != null) {
            this.ensureValid(this.role.getValueType(), value.getType());
            this.values.add(value);
        }
    }

    @Override
    public void setValues(Collection<? extends Feature> newValues) {
        if (newValues != this.values) {
            ArgumentChecks.ensureNonNull("values", newValues);
            FeatureType base = this.role.getValueType();
            this.values.clear();
            for (Feature feature : newValues) {
                this.ensureValid(base, feature.getType());
                this.values.add(feature);
            }
        }
    }

    @Override
    public MultiValuedAssociation clone() throws CloneNotSupportedException {
        MultiValuedAssociation clone = (MultiValuedAssociation)super.clone();
        clone.values = (CheckedArrayList)clone.values.clone();
        return clone;
    }

    public int hashCode() {
        return this.role.hashCode() + this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiValuedAssociation) {
            MultiValuedAssociation that = (MultiValuedAssociation)obj;
            return this.role.equals((Object)that.role) && this.values.equals(that.values);
        }
        return false;
    }
}

