/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class SpatialOperationContext
implements Serializable {
    private static final long serialVersionUID = -6197547343970700471L;
    private static final int BIDIMENSIONAL = 2;
    private final GeographicBoundingBox areaOfInterest;
    private final CoordinateReferenceSystem computationCRS;
    private final Unit<?> systemUnit;
    private final int skipIndex;
    CoordinateReferenceSystem commonCRS;

    public SpatialOperationContext(GeographicBoundingBox areaOfInterest, GeometryWrapper<?> literal, Unit<?> systemUnit, int skipIndex) throws FactoryException, TransformException, IncommensurableException {
        this.areaOfInterest = areaOfInterest;
        this.systemUnit = systemUnit;
        this.skipIndex = skipIndex;
        if (literal == null) {
            this.computationCRS = null;
        } else {
            try {
                CoordinateReferenceSystem crs = SpatialOperationContext.to2D(literal.getCoordinateReferenceSystem());
                if (systemUnit != null && crs != null) {
                    crs = SpatialOperationContext.usingSystemUnit(literal, crs, crs, systemUnit);
                }
                this.computationCRS = crs;
            }
            catch (BackingStoreException e) {
                throw e.unwrapOrRethrow(FactoryException.class);
            }
        }
    }

    private static CoordinateReferenceSystem to2D(CoordinateReferenceSystem crs) {
        if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)crs) > 2) {
            crs = CRS.getComponentAt((CoordinateReferenceSystem)crs, (int)0, (int)2);
        }
        return crs;
    }

    public <G> GeometryWrapper<G> transform(GeometryWrapper<G> geometry) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (this.computationCRS != null && (sourceCRS = SpatialOperationContext.to2D(geometry.getCoordinateReferenceSystem())) != null && !Utilities.equalsIgnoreMetadata(this.computationCRS, sourceCRS)) {
            geometry = geometry.transform(CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.computationCRS, (GeographicBoundingBox)this.areaOfInterest), false);
        }
        return geometry;
    }

    final <G> boolean transform(GeometryWrapper<G>[] geometries) throws FactoryException, TransformException, IncommensurableException {
        int i;
        CoordinateReferenceSystem[] allCRS;
        block14: {
            allCRS = new CoordinateReferenceSystem[geometries.length];
            try {
                i = allCRS.length;
                while (--i >= 0) {
                    allCRS[i] = i == this.skipIndex ? this.computationCRS : SpatialOperationContext.to2D(geometries[i].getCoordinateReferenceSystem());
                }
            }
            catch (BackingStoreException e) {
                throw e.unwrapOrRethrow(FactoryException.class);
            }
            i = allCRS.length;
            do {
                if (--i >= 0) continue;
                return true;
            } while ((this.commonCRS = allCRS[i]) == null);
            boolean reject = false;
            if (this.systemUnit != null && this.commonCRS != this.computationCRS) {
                reject = SpatialOperationContext.isCompatibleUnit(this.commonCRS, this.systemUnit);
            }
            if (!reject) {
                CoordinateReferenceSystem crs;
                do {
                    if (--i >= 0) continue;
                    return true;
                } while ((crs = allCRS[i]) == null || Utilities.equalsIgnoreMetadata(this.commonCRS, crs));
            }
            this.commonCRS = this.computationCRS;
            if (this.commonCRS == null) {
                if (this.systemUnit != null) {
                    i = allCRS.length;
                    while (--i >= 0) {
                        this.commonCRS = allCRS[i];
                        Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)this.commonCRS);
                        if (unit == null || !this.systemUnit.equals((Object)unit.getSystemUnit())) continue;
                        break block14;
                    }
                }
                this.commonCRS = CRS.suggestCommonTarget((GeographicBoundingBox)this.areaOfInterest, (CoordinateReferenceSystem[])allCRS);
                if (this.commonCRS == null) {
                    return false;
                }
                if (this.systemUnit != null) {
                    i = allCRS.length;
                    while (--i >= 0) {
                        CoordinateReferenceSystem crs = allCRS[i];
                        if (crs == null) continue;
                        this.commonCRS = SpatialOperationContext.usingSystemUnit(geometries[i], crs, this.commonCRS, this.systemUnit);
                        break block14;
                    }
                    return false;
                }
            }
        }
        for (i = 0; i < allCRS.length; ++i) {
            CoordinateReferenceSystem sourceCRS;
            if (i == this.skipIndex || Utilities.equalsIgnoreMetadata(this.commonCRS, sourceCRS = allCRS[i])) continue;
            geometries[i] = geometries[i].transform(CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.commonCRS, (GeographicBoundingBox)this.areaOfInterest), false);
        }
        return true;
    }

    private static boolean isCompatibleUnit(CoordinateReferenceSystem crs, Unit<?> systemUnit) {
        Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)crs);
        return unit != null && systemUnit.equals((Object)unit.getSystemUnit());
    }

    private static CoordinateReferenceSystem usingSystemUnit(GeometryWrapper<?> geometry, CoordinateReferenceSystem geometryCRS, CoordinateReferenceSystem targetCRS, Unit<?> systemUnit) throws FactoryException, TransformException, IncommensurableException {
        while (!SpatialOperationContext.isCompatibleUnit(targetCRS, systemUnit)) {
            if (Units.isLinear(systemUnit) && targetCRS instanceof GeographicCRS) {
                return Projector.instance().create((GeographicCRS)targetCRS, geometry.getCentroid(), geometryCRS);
            }
            if (targetCRS instanceof GeneralDerivedCRS) {
                targetCRS = ((GeneralDerivedCRS)targetCRS).getBaseCRS();
                continue;
            }
            throw new IncommensurableException(Errors.format((short)70, systemUnit));
        }
        return targetCRS;
    }

    public static boolean negativeResult(SpatialOperatorName type) {
        return type == SpatialOperatorName.DISJOINT;
    }

    public static boolean negativeResult(DistanceOperatorName type) {
        return type == DistanceOperatorName.BEYOND;
    }

    private static final class Projector {
        private static final boolean CONTINUOUS_WRAPAROUND = false;
        private final Map<String, ?> name;
        private final OperationMethod method;
        private final CartesianCS cartCS;
        private static final Projector INSTANCE;

        private Projector() throws FactoryException {
            ReferencingFactoryContainer f = new ReferencingFactoryContainer();
            this.method = f.getCoordinateOperationFactory().getOperationMethod("Mercator_2SP");
            this.cartCS = f.getStandardProjectedCS();
            this.name = Map.of("name", new ImmutableIdentifier(Citations.SIS, "SIS", "Mercator for geometry"));
        }

        ProjectedCRS create(GeographicCRS baseCRS, DirectPosition centroid, CoordinateReferenceSystem geometryCRS) throws FactoryException, TransformException, IncommensurableException {
            while (geometryCRS instanceof GeneralDerivedCRS) {
                GeneralDerivedCRS g = (GeneralDerivedCRS)geometryCRS;
                centroid = g.getConversionFromBase().getMathTransform().inverse().transform(centroid, centroid);
                geometryCRS = g.getBaseCRS();
            }
            if (!(geometryCRS instanceof GeographicCRS)) {
                throw new FactoryException(Errors.format((short)47, ReferencingUtilities.getInterface(CoordinateReferenceSystem.class, (IdentifiedObject)geometryCRS)));
            }
            CoordinateSystem cs = geometryCRS.getCoordinateSystem();
            double latitude = Double.NaN;
            double longitude = Double.NaN;
            for (int i = 0; i < 2; ++i) {
                CoordinateSystemAxis axis = cs.getAxis(i);
                double coordinate = centroid.getOrdinate(i);
                coordinate = axis.getUnit().getConverterToAny(Units.DEGREE).convert(coordinate);
                AxisDirection direction = axis.getDirection();
                if (direction == AxisDirection.NORTH) {
                    latitude = coordinate;
                    continue;
                }
                if (direction == AxisDirection.EAST) {
                    longitude = coordinate;
                    continue;
                }
                if (direction == AxisDirection.WEST) {
                    longitude = -coordinate;
                    continue;
                }
                if (direction == AxisDirection.SOUTH) {
                    latitude = -coordinate;
                    continue;
                }
                throw new FactoryException(Errors.format((short)177, direction));
            }
            ParameterValueGroup p = this.method.getParameters().createValue();
            p.parameter("standard_parallel_1").setValue(latitude);
            DefaultConversion conversion = new DefaultConversion(this.name, this.method, null, p);
            return new DefaultProjectedCRS(this.name, baseCRS, (Conversion)conversion, this.cartCS);
        }

        static Projector instance() throws FactoryException {
            return INSTANCE != null ? INSTANCE : new Projector();
        }

        static {
            Projector b;
            try {
                b = new Projector();
            }
            catch (FactoryException e) {
                b = null;
            }
            INSTANCE = b;
        }
    }
}

