/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.Map;
import org.apache.sis.internal.processing.isoline.Fragments;

enum PolylineStage {
    BUFFER,
    FRAGMENT,
    FINAL;


    private Path2D destination(Map<PolylineStage, Path2D> appendTo) {
        return appendTo.computeIfAbsent(this, k -> new Path2D.Float());
    }

    final void add(Map<PolylineStage, Path2D> appendTo, double[] coordinates, int size) {
        int i = 0;
        if (i < size) {
            Path2D p = this.destination(appendTo);
            p.moveTo(coordinates[i++], coordinates[i++]);
            while (i < size) {
                p.lineTo(coordinates[i++], coordinates[i++]);
            }
        }
    }

    final void add(Map<PolylineStage, Path2D> appendTo, Map<?, Fragments> partialPaths) {
        for (Fragments fragment : partialPaths.values()) {
            for (double[] coordinates : fragment) {
                if (coordinates == null) continue;
                this.add(appendTo, coordinates, coordinates.length);
            }
        }
    }

    final void add(Map<PolylineStage, Path2D> appendTo, Shape polylines) {
        if (polylines != null) {
            this.destination(appendTo).append(polylines, false);
        }
    }
}

