/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.geotoolkit.temporal.object.DefaultTemporalTopologicalPrimitive;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalEdge;
import org.opengis.temporal.TemporalNode;
import org.opengis.temporal.TemporalTopologicalPrimitive;

@XmlType(name="TimeEdge_Type", propOrder={"start", "end", "realization"})
@XmlRootElement(name="TimeEdge")
public class DefaultTemporalEdge
extends DefaultTemporalTopologicalPrimitive
implements TemporalEdge {
    private Period realization;
    private TemporalNode start;
    private TemporalNode end;

    public DefaultTemporalEdge(Map<String, ?> properties, Period realization, TemporalNode start, TemporalNode end) {
        super(properties);
        Object remarks = properties.get("remarks");
        if (remarks != null) {
            throw new IllegalArgumentException("remarks argument should be null");
        }
        this.realization = realization;
        this.start = start;
        this.end = end;
    }

    private DefaultTemporalEdge(TemporalEdge object) {
        super((TemporalTopologicalPrimitive)object);
        if (object != null) {
            this.realization = object.getRealization();
            this.start = object.getStart();
            this.end = object.getEnd();
        }
    }

    public static DefaultTemporalEdge castOrCopy(TemporalEdge object) {
        if (object == null || object instanceof DefaultTemporalEdge) {
            return (DefaultTemporalEdge)object;
        }
        return new DefaultTemporalEdge(object);
    }

    private DefaultTemporalEdge() {
    }

    @XmlElement(name="extent")
    public Period getRealization() {
        return this.realization;
    }

    @XmlElement(name="start", required=true)
    public TemporalNode getStart() {
        return this.start;
    }

    @XmlElement(name="end", required=true)
    public TemporalNode getEnd() {
        return this.end;
    }
}

