/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.datum.Ellipsoid;

@XmlRootElement(name="SecondDefiningParameter", namespace="http://www.opengis.net/gml/3.2")
public final class SecondDefiningParameter {
    @XmlElement(name="SecondDefiningParameter")
    public SecondDefiningParameter secondDefiningParameter;
    @XmlElement
    public Boolean isSphere;
    public Measure measure;

    public SecondDefiningParameter() {
    }

    public SecondDefiningParameter(Ellipsoid ellipsoid, boolean nested) {
        if (nested) {
            this.secondDefiningParameter = new SecondDefiningParameter(ellipsoid, false);
        } else if (ellipsoid.isSphere()) {
            this.isSphere = Boolean.TRUE;
        } else {
            this.measure = ellipsoid.isIvfDefinitive() ? new Measure(ellipsoid.getInverseFlattening(), Units.UNITY) : new Measure(ellipsoid.getSemiMinorAxis(), ellipsoid.getAxisUnit());
        }
    }

    public boolean isIvfDefinitive() {
        return this.measure != null && Units.UNITY.equals(this.measure.unit);
    }

    @XmlElement(name="semiMinorAxis")
    public Measure getSemiMinorAxis() {
        return this.isIvfDefinitive() ? null : this.measure;
    }

    public void setSemiMinorAxis(Measure measure) {
        this.measure = measure;
    }

    @XmlElement(name="inverseFlattening")
    public Measure getInverseFlattening() {
        return this.isIvfDefinitive() ? this.measure : null;
    }

    public void setInverseFlattening(Measure measure) {
        if (measure.setUnit(Units.UNITY)) {
            Context.warningOccured(Context.current(), SecondDefiningParameter.class, "setInverseFlattening", Errors.class, (short)63, "uom");
        }
        this.measure = measure;
    }
}

