/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.UnmodifiableParameterValueGroup;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

final class FilteredParameters
extends UnmodifiableParameterValueGroup {
    private static final long serialVersionUID = 4880548875706032438L;
    private final GeneralParameterValue[] filtered;

    private FilteredParameters(UnmodifiableParameterValueGroup source, GeneralParameterValue[] filtered) {
        super(source);
        this.filtered = filtered;
    }

    static UnmodifiableParameterValueGroup create(UnmodifiableParameterValueGroup source, Predicate<? super GeneralParameterDescriptor> filter) {
        if (source != null && filter != null) {
            List<GeneralParameterValue> sources = source.values();
            GeneralParameterValue[] filtered = new GeneralParameterValue[sources.size()];
            int count = 0;
            for (GeneralParameterValue value : sources) {
                if (!filter.test((GeneralParameterDescriptor)value.getDescriptor())) continue;
                filtered[count++] = value;
            }
            if (count != filtered.length) {
                return new FilteredParameters(source, Arrays.copyOf(filtered, count));
            }
        }
        return source;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return UnmodifiableArrayList.wrap(this.filtered);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode) && mode == ComparisonMode.STRICT) {
            FilteredParameters other = (FilteredParameters)object;
            return Arrays.equals(this.filtered, other.filtered);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.filtered.length;
    }
}

