/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;

@XmlType(name="TimeCSType")
@XmlRootElement(name="TimeCS")
public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;

    private DefaultTimeCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        super(properties, axes);
    }

    public DefaultTimeCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, axis);
    }

    protected DefaultTimeCS(TimeCS cs) {
        super((CoordinateSystem)cs);
    }

    public static DefaultTimeCS castOrCopy(TimeCS object) {
        return object == null || object instanceof DefaultTimeCS ? (DefaultTimeCS)object : new DefaultTimeCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirection.FUTURE.equals(AxisDirections.absolute(direction))) {
            return 1;
        }
        if (!Units.isTemporal(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends TimeCS> getInterface() {
        return TimeCS.class;
    }

    @Override
    public DefaultTimeCS forConvention(AxesConvention convention) {
        return (DefaultTimeCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return new DefaultTimeCS(properties, axes);
            }
        }
        throw DefaultTimeCS.unexpectedDimension(properties, axes, 1);
    }

    private DefaultTimeCS() {
    }
}

