/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LocalizationGridBuilder
extends TransformBuilder {
    private static final double EPS = 1.0E-13;
    private final LinearTransformBuilder linearBuilder;
    private final int[] gridCoordinates = new int[2];
    private LinearTransform sourceToGrid;
    private double precision;
    private static final double DEFAULT_PRECISION = 1.0E-7;
    private MathTransform transform;
    private double[] periods;

    public LocalizationGridBuilder(int width, int height) {
        this.linearBuilder = new LinearTransformBuilder(width, height);
        this.sourceToGrid = MathTransforms.identity(2);
    }

    public LocalizationGridBuilder(Vector sourceX, Vector sourceY) {
        Matrix3 fromGrid = new Matrix3();
        int width = LocalizationGridBuilder.infer(sourceX, fromGrid, 0);
        int height = LocalizationGridBuilder.infer(sourceY, fromGrid, 1);
        this.linearBuilder = new LinearTransformBuilder(width, height);
        try {
            this.sourceToGrid = MathTransforms.linear(fromGrid).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw (ArithmeticException)new ArithmeticException(e.getLocalizedMessage()).initCause(e);
        }
    }

    public LocalizationGridBuilder(LinearTransformBuilder localizations) {
        ArgumentChecks.ensureNonNull("localizations", localizations);
        int n = localizations.getGridDimensions();
        if (n != 2) {
            Vector[] sources;
            if (n < 0 && (n = (sources = localizations.sources()).length) == 2) {
                Matrix3 fromGrid = new Matrix3();
                int width = LocalizationGridBuilder.infer(sources[0], fromGrid, 0);
                int height = LocalizationGridBuilder.infer(sources[1], fromGrid, 1);
                this.linearBuilder = new LinearTransformBuilder(width, height);
                this.linearBuilder.setControlPoints(localizations.getControlPoints());
                try {
                    this.sourceToGrid = MathTransforms.linear(fromGrid).inverse();
                }
                catch (NoninvertibleTransformException e) {
                    throw (ArithmeticException)new ArithmeticException(e.getLocalizedMessage()).initCause(e);
                }
                this.linearBuilder.setLinearizers(localizations);
                return;
            }
            throw new IllegalArgumentException(Errors.format((short)190, "localizations", 0, 2, n));
        }
        this.linearBuilder = localizations;
        this.sourceToGrid = MathTransforms.identity(2);
    }

    private static int infer(Vector source, Matrix fromGrid, int dim) {
        double inc;
        NumberRange<?> range = source.range();
        double min = range.getMinDouble(true);
        double span = range.getSpan();
        Number increment = source.increment(1.0E-13 * span);
        if (increment != null) {
            inc = increment.doubleValue();
        } else {
            inc = span;
            int size = source.size();
            for (int i = 0; i < size; ++i) {
                double r;
                double v = source.doubleValue(i) - min;
                if (!(Math.abs(v % inc) > 1.0E-13)) continue;
                do {
                    r = inc % v;
                    inc = v;
                } while (Math.abs(v = r) > 1.0E-13);
            }
        }
        fromGrid.setElement(dim, dim, inc);
        fromGrid.setElement(dim, 2, min);
        double n = span / inc;
        if (n >= 0.5 && n < (double)source.size() - 0.5) {
            return (int)Math.round(n) + 1;
        }
        throw new ArithmeticException(Resources.format((short)75, range));
    }

    private void ensureModifiable() throws IllegalStateException {
        if (!this.linearBuilder.isModifiable()) {
            throw new IllegalStateException(Errors.format((short)153, LocalizationGridBuilder.class));
        }
    }

    public void setDesiredPrecision(double precision) {
        this.ensureModifiable();
        ArgumentChecks.ensureStrictlyPositive("precision", precision);
        this.precision = precision;
    }

    public double getDesiredPrecision() {
        return this.precision;
    }

    public void setSourceToGrid(LinearTransform sourceToGrid) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("sourceToGrid", sourceToGrid);
        int isTarget = 0;
        int dim = sourceToGrid.getSourceDimensions();
        if (dim >= 2) {
            isTarget = 1;
            dim = sourceToGrid.getTargetDimensions();
            if (dim == 2) {
                this.sourceToGrid = sourceToGrid;
                return;
            }
        }
        throw new MismatchedDimensionException(Errors.format((short)190, "sourceToGrid", isTarget, 2, dim));
    }

    public LinearTransform getSourceToGrid() {
        return this.sourceToGrid;
    }

    public Envelope getSourceEnvelope(boolean fullArea) throws TransformException {
        Envelope envelope = this.linearBuilder.getSourceEnvelope();
        if (fullArea) {
            int i = envelope.getDimension();
            while (--i >= 0) {
                GeneralEnvelope ge = GeneralEnvelope.castOrCopy(envelope);
                ge.setRange(i, ge.getLower(i) - 0.5, ge.getUpper(i) + 0.5);
                envelope = ge;
            }
        }
        return Envelopes.transform(this.sourceToGrid.inverse(), envelope);
    }

    public void setControlPoints(Vector ... coordinates) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("coordinates", coordinates);
        this.linearBuilder.setControlPoints(coordinates);
    }

    public void setControlPoint(int gridX, int gridY, double ... target) {
        this.ensureModifiable();
        this.gridCoordinates[0] = gridX;
        this.gridCoordinates[1] = gridY;
        this.linearBuilder.setControlPoint(this.gridCoordinates, target);
    }

    public double[] getControlPoint(int gridX, int gridY) {
        this.gridCoordinates[0] = gridX;
        this.gridCoordinates[1] = gridY;
        return this.linearBuilder.getControlPoint(this.gridCoordinates);
    }

    public Vector getRow(int dimension, int row) {
        this.gridCoordinates[0] = 0;
        this.gridCoordinates[1] = row;
        return this.linearBuilder.getTransect(dimension, this.gridCoordinates, 0);
    }

    public Vector getColumn(int dimension, int column) {
        this.gridCoordinates[0] = column;
        this.gridCoordinates[1] = 0;
        return this.linearBuilder.getTransect(dimension, this.gridCoordinates, 1);
    }

    public NumberRange<Double> resolveWraparoundAxis(int dimension, int direction, double period) {
        this.ensureModifiable();
        ArgumentChecks.ensureBetween("dimension", 0, this.linearBuilder.getTargetDimensions() - 1, dimension);
        ArgumentChecks.ensureBetween("direction", 0, this.linearBuilder.getSourceDimensions() - 1, direction);
        ArgumentChecks.ensureStrictlyPositive("period", period);
        if (this.periods == null) {
            this.periods = new double[this.linearBuilder.getTargetDimensions()];
        }
        if (this.periods[dimension] != 0.0) {
            throw new IllegalStateException(Errors.format((short)164, Strings.bracket("periods", (Object)dimension)));
        }
        this.periods[dimension] = period;
        return this.linearBuilder.resolveWraparoundAxis(dimension, direction, period);
    }

    public void addLinearizers(Map<String, MathTransform> projections, boolean compensate, int ... projToGrid) {
        ArgumentChecks.ensureNonNull("projections", projections);
        this.ensureModifiable();
        this.linearBuilder.addLinearizers(projections, compensate, projToGrid);
    }

    @Override
    public MathTransform create(MathTransformFactory factory) throws FactoryException {
        if (this.transform == null) {
            MathTransform step;
            LinearTransform gridToCoord = this.linearBuilder.create(factory);
            boolean isExact = true;
            boolean isLinear = true;
            for (double c : this.linearBuilder.correlation()) {
                isExact &= c == 1.0;
                if (c >= 0.9999) continue;
                isLinear = false;
                break;
            }
            if (isExact) {
                step = MathTransforms.concatenate(this.sourceToGrid, gridToCoord);
            } else {
                int width = this.linearBuilder.gridSize(0);
                int height = this.linearBuilder.gridSize(1);
                float[] residual = new float[2 * this.linearBuilder.gridLength];
                double[] grid = new double[2 * width];
                double gridPrecision = this.precision;
                try {
                    if (gridPrecision > 0.0 && !this.sourceToGrid.isIdentity()) {
                        double[] vector = new double[this.sourceToGrid.getSourceDimensions()];
                        double[] offset = new double[this.sourceToGrid.getTargetDimensions()];
                        double converted = 0.0;
                        for (int i = 0; i < vector.length; ++i) {
                            vector[i] = this.precision;
                            this.sourceToGrid.deltaTransform(vector, 0, offset, 0, 1);
                            double length = MathFunctions.magnitude(offset);
                            if (length > converted) {
                                converted = length;
                            }
                            vector[i] = 0.0;
                        }
                        gridPrecision = converted;
                    }
                    LinearTransform coordToGrid = gridToCoord.inverse();
                    int k = 0;
                    for (int y = 0; y < height; ++y) {
                        this.gridCoordinates[0] = 0;
                        this.gridCoordinates[1] = y;
                        this.linearBuilder.getControlRow(this.gridCoordinates, grid);
                        coordToGrid.transform(grid, 0, grid, 0, width);
                        int i = 0;
                        for (int x = 0; x < width; ++x) {
                            double dx = grid[i++] - (double)x;
                            double dy = grid[i++] - (double)y;
                            isLinear &= dx <= gridPrecision;
                            isLinear &= dy <= gridPrecision;
                            residual[k++] = (float)dx;
                            residual[k++] = (float)dy;
                        }
                    }
                    if (isLinear) {
                        step = MathTransforms.concatenate(this.sourceToGrid, gridToCoord);
                    } else {
                        ResidualGrid shifts = new ResidualGrid(this.sourceToGrid, gridToCoord, width, height, residual, gridPrecision > 0.0 ? gridPrecision : 1.0E-7, this.periods, this.linearBuilder.appliedLinearizer());
                        step = InterpolatedTransform.createGeodeticTransformation(LocalizationGridBuilder.nonNull(factory), shifts);
                    }
                }
                catch (TransformException e) {
                    throw new LocalizationGridException(e);
                }
            }
            ProjectedTransformTry linearizer = this.linearBuilder.appliedLinearizer();
            if (linearizer != null && linearizer.reverseAfterLinearization) {
                try {
                    step = factory.createConcatenatedTransform(step, linearizer.getValue().inverse());
                }
                catch (NoninvertibleTransformException e) {
                    throw new InvalidGeodeticParameterException(Resources.format((short)52, linearizer.getKey()), e);
                }
            }
            this.transform = step;
        }
        return this.transform;
    }

    public Optional<Map.Entry<String, MathTransform>> linearizer(boolean ifNotCompensated) {
        ProjectedTransformTry linearizer = this.linearBuilder.appliedLinearizer();
        if (ifNotCompensated && linearizer != null && linearizer.reverseAfterLinearization) {
            linearizer = null;
        }
        return Optional.ofNullable(linearizer);
    }

    public Statistics[] errors(boolean linear) {
        MathTransform inverse;
        MathTransform complete;
        MathTransform mt;
        MathTransform mathTransform = mt = linear ? this.linearBuilder.transform() : this.transform;
        if (mt == null) {
            throw new IllegalStateException(Errors.format((short)189, this.getClass().getSimpleName()));
        }
        int tgtDim = mt.getTargetDimensions();
        double[] point = new double[Math.max(tgtDim, 2)];
        Statistics[] stats = new Statistics[tgtDim + 2];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < stats.length; ++i) {
            buffer.setLength(0);
            buffer.append('\u0394');
            if (i < tgtDim) {
                if (i < 3) {
                    buffer.append((char)(120 + i));
                } else {
                    buffer.append('z').append(i - 1);
                }
            } else {
                buffer.append((char)(105 + (i - tgtDim)));
            }
            stats[i] = new Statistics(buffer.toString());
        }
        try {
            ProjectedTransformTry linearizer = this.linearBuilder.appliedLinearizer();
            complete = linearizer != null && linearizer.reverseAfterLinearization ? linearizer.getValue().inverse() : null;
            inverse = mt.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        int width = this.linearBuilder.gridSize(0);
        int height = this.linearBuilder.gridSize(1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i;
                double[] expected;
                block16: {
                    this.gridCoordinates[0] = x;
                    point[0] = this.gridCoordinates[0];
                    this.gridCoordinates[1] = y;
                    point[1] = this.gridCoordinates[1];
                    try {
                        mt.transform(point, 0, point, 0, 1);
                        expected = this.linearBuilder.getControlPoint(this.gridCoordinates);
                        if (complete == null) break block16;
                        complete.transform(expected, 0, expected, 0, 1);
                    }
                    catch (TransformException e) {
                        continue;
                    }
                }
                for (i = 0; i < tgtDim; ++i) {
                    stats[i].accept(point[i] - expected[i]);
                }
                try {
                    inverse.transform(expected, 0, expected, 0, 1);
                }
                catch (TransformException e) {
                    continue;
                }
                for (i = 0; i < 2; ++i) {
                    stats[tgtDim + i].accept(expected[i] - (double)this.gridCoordinates[i]);
                }
            }
        }
        return stats;
    }

    public String toString(boolean linear, Locale locale) {
        StringBuilder buffer = new StringBuilder(400);
        String lineSeparator = null;
        try {
            lineSeparator = this.linearBuilder.appendTo(buffer, this.getClass(), locale, (short)116);
            if (this.transform != null) {
                buffer.append("\u25b6\u00a0");
                Vocabulary vocabulary = Vocabulary.getResources(locale);
                vocabulary.appendLabel((short)80, buffer);
                buffer.append(lineSeparator);
                StatisticsFormat sf = locale != null ? StatisticsFormat.getInstance(locale) : StatisticsFormat.getInstance();
                sf.format(this.errors(linear), (Appendable)buffer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Strings.insertLineInLeftMargin(buffer, lineSeparator);
        return buffer.toString();
    }

    public String toString() {
        return this.toString(false, null);
    }
}

