/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.xml.XmlUtilities;

@XmlType(name="DateTime_PropertyType")
public class GO_DateTime
extends XmlAdapter<GO_DateTime, Date> {
    @XmlElement(name="DateTime")
    @XmlSchemaType(name="dateTime")
    private XMLGregorianCalendar dateTime;
    @XmlElement(name="Date")
    @XmlSchemaType(name="date")
    private XMLGregorianCalendar date;

    public GO_DateTime() {
    }

    private GO_DateTime(Date date) {
        Context context = Context.current();
        try {
            XMLGregorianCalendar gc = XmlUtilities.toXML(context, date);
            if (Context.isFlagSet(context, 32)) {
                if (XmlUtilities.trimTime(gc, false)) {
                    this.date = gc;
                } else {
                    this.dateTime = gc;
                }
            } else {
                if (gc.getMillisecond() == 0) {
                    gc.setMillisecond(Integer.MIN_VALUE);
                }
                this.dateTime = gc;
            }
        }
        catch (DatatypeConfigurationException e) {
            Context.warningOccured(context, XmlAdapter.class, "marshal", e, true);
        }
    }

    private Date getDate() {
        return XmlUtilities.toDate(Context.current(), this.dateTime != null ? this.dateTime : this.date);
    }

    public final Date unmarshal(GO_DateTime value) {
        return value != null ? value.getDate() : null;
    }

    public GO_DateTime marshal(Date value) {
        return value != null ? new GO_DateTime(value) : null;
    }

    public static final class Since2014
    extends GO_DateTime {
        @Override
        public GO_DateTime marshal(Date value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

