/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Currency;
import java.util.Date;
import org.apache.sis.internal.jaxb.gco.GO_Record;
import org.apache.sis.internal.jaxb.gco.GO_RecordType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_StandardOrderProcess_Type", propOrder={"fees", "plannedAvailableDateTime", "orderingInstructions", "turnaround", "orderOptionsType", "orderOptions"})
@XmlRootElement(name="MD_StandardOrderProcess")
public class DefaultStandardOrderProcess
extends ISOMetadata
implements StandardOrderProcess {
    private static final long serialVersionUID = 1948951192071039775L;
    private InternationalString fees;
    private Currency currency;
    private long plannedAvailableDateTime = Long.MIN_VALUE;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;
    private RecordType orderOptionsType;
    private Record orderOptions;

    public DefaultStandardOrderProcess() {
    }

    public DefaultStandardOrderProcess(StandardOrderProcess object) {
        super(object);
        if (object != null) {
            this.fees = object.getFees();
            this.plannedAvailableDateTime = ImplementationHelper.toMilliseconds(object.getPlannedAvailableDateTime());
            this.orderingInstructions = object.getOrderingInstructions();
            this.turnaround = object.getTurnaround();
            this.orderOptionsType = object.getOrderOptionsType();
            this.orderOptions = object.getOrderOptions();
        }
    }

    public static DefaultStandardOrderProcess castOrCopy(StandardOrderProcess object) {
        if (object == null || object instanceof DefaultStandardOrderProcess) {
            return (DefaultStandardOrderProcess)object;
        }
        return new DefaultStandardOrderProcess(object);
    }

    @XmlElement(name="fees")
    public InternationalString getFees() {
        return this.fees;
    }

    public void setFees(InternationalString newValue) {
        this.checkWritePermission(this.fees);
        this.fees = newValue;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency newValue) {
        this.checkWritePermission(this.currency);
        this.currency = newValue;
    }

    @XmlElement(name="plannedAvailableDateTime")
    public Date getPlannedAvailableDateTime() {
        return ImplementationHelper.toDate(this.plannedAvailableDateTime);
    }

    public void setPlannedAvailableDateTime(Date newValue) {
        this.checkWritePermission(this.plannedAvailableDateTime);
        this.plannedAvailableDateTime = ImplementationHelper.toMilliseconds(newValue);
    }

    @XmlElement(name="orderingInstructions")
    public InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public void setOrderingInstructions(InternationalString newValue) {
        this.checkWritePermission(this.orderingInstructions);
        this.orderingInstructions = newValue;
    }

    @XmlElement(name="turnaround")
    public InternationalString getTurnaround() {
        return this.turnaround;
    }

    public void setTurnaround(InternationalString newValue) {
        this.checkWritePermission(this.turnaround);
        this.turnaround = newValue;
    }

    @XmlElement(name="orderOptionsType")
    @XmlJavaTypeAdapter(value=GO_RecordType.Since2014.class)
    public RecordType getOrderOptionsType() {
        return this.orderOptionsType;
    }

    public void setOrderOptionsType(RecordType newValue) {
        this.checkWritePermission(this.orderOptionsType);
        this.orderOptionsType = newValue;
    }

    @XmlElement(name="orderOptions")
    @XmlJavaTypeAdapter(value=GO_Record.Since2014.class)
    public Record getOrderOptions() {
        return this.orderOptions;
    }

    public void setOrderOptions(Record newValue) {
        this.checkWritePermission(this.orderOptions);
        this.orderOptions = newValue;
    }
}

