/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlType;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GridEnvelopeType", propOrder={"low", "high"})
public class GridEnvelopeType {
    @XmlList
    @XmlElement(required=true)
    private long[] low;
    @XmlList
    @XmlElement(required=true)
    private long[] high;

    GridEnvelopeType() {
    }

    public GridEnvelopeType(GridEnvelope env) {
        if (env != null) {
            if (env.getHigh() != null) {
                this.high = env.getHigh().getCoordinateValues();
            }
            if (env.getLow() != null) {
                this.low = env.getLow().getCoordinateValues();
            }
        }
    }

    public GridEnvelopeType(long[] low, long[] high) {
        this.high = high;
        this.low = low;
    }

    public GridCoordinates getLow() {
        if (this.low != null) {
            return new GmlGridCoordinates(this.low);
        }
        return null;
    }

    public GridCoordinates getHigh() {
        if (this.high != null) {
            return new GmlGridCoordinates(this.high);
        }
        return null;
    }

    public int getDimension() {
        if (this.low != null) {
            return this.low.length;
        }
        return 0;
    }

    public long getLow(int i) throws IndexOutOfBoundsException {
        if (this.low != null && i < this.low.length) {
            return this.low[i];
        }
        return -1L;
    }

    public long getHigh(int i) throws IndexOutOfBoundsException {
        if (this.high != null && i < this.high.length) {
            return this.high[i];
        }
        return -1L;
    }

    public int getSpan(int i) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class GmlGridCoordinates
    implements GridCoordinates {
        final long[] coordinates;

        public GmlGridCoordinates(long[] coordinates) {
            this.coordinates = (long[])coordinates.clone();
        }

        public int getDimension() {
            if (this.coordinates != null) {
                return this.coordinates.length;
            }
            return -1;
        }

        public long[] getCoordinateValues() {
            if (this.coordinates != null) {
                return (long[])this.coordinates.clone();
            }
            return null;
        }

        public long getCoordinateValue(int dimension) throws IndexOutOfBoundsException {
            if (this.coordinates != null) {
                return this.coordinates[dimension];
            }
            return -1L;
        }

        public void setCoordinateValue(int dimension, long value) throws IndexOutOfBoundsException, UnsupportedOperationException {
            if (this.coordinates != null) {
                this.coordinates[dimension] = value;
            }
        }
    }
}

