/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class WfsKvpRequest {
    private final Map<String, String> kvps = new HashMap<String, String>();

    public void addKvp(String key, String value) {
        if (key != null) {
            this.kvps.put(key, this.encode(value));
        }
    }

    public String asQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> kvp : this.kvps.entrySet()) {
            if (sb.length() > 1) {
                sb.append('&');
            }
            sb.append(kvp.getKey()).append('=').append(kvp.getValue());
        }
        return sb.toString();
    }

    public void removeKvp(String key) {
        this.kvps.remove(key);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value;
        }
    }
}

