/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.wfs20.core.dgiwg.testsuite.WfsBaseFixture;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class GetCapabilitiesOperationConstraintsTest
extends WfsBaseFixture {
    private static final String XPATH_SERVICE_CONSTRAINT = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Constraint[@name='%s']/ows:DefaultValue";
    private static final String XPATH_OPERATION = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='%s']";
    private static final String XPATH_CONSTRAINT_PER_OPERATION = "ows:Constraint[@name='%s']/ows:DefaultValue";

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.3., S.31, Requirement 22")
    public void wfsCapabilitiesAutomaticDataLockingExists() throws XPathFactoryConfigurationException, XPathExpressionException {
        boolean hasServiceOrOperationConstraint;
        String constraintName = "AutomaticDataLocking";
        String xPathServiceConstraint = String.format(XPATH_SERVICE_CONSTRAINT, constraintName);
        Node serviceConstraintNode = this.selectNode(xPathServiceConstraint);
        boolean bl = hasServiceOrOperationConstraint = serviceConstraintNode != null;
        if (serviceConstraintNode == null) {
            Map<String, Node> operationConstraintNodes = this.retrieveOperationToConstraint(constraintName, "Transaction");
            hasServiceOrOperationConstraint = operationConstraintNodes.get("Transaction") != null;
        }
        Assert.assertTrue((boolean)hasServiceOrOperationConstraint, (String)"Constraint 'AutomaticDataLocking' is missing. Expected is the constraint as service or operation constraints for operation 'Transaction'");
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.3., S.31, Requirement 22")
    public void wfsCapabilitiesCountDefaultGreaterOrEqualTo0() throws XPathFactoryConfigurationException, XPathExpressionException {
        String constraintName = "CountDefault";
        String xPathServiceConstraint = String.format(XPATH_SERVICE_CONSTRAINT, constraintName);
        Node serviceConstraintNode = this.selectNode(xPathServiceConstraint);
        boolean hasServiceConstraint = serviceConstraintNode != null;
        Map<String, Node> operationConstraintNodes = this.retrieveOperationToConstraintForGetFeatureBundle(constraintName);
        boolean hasOperationConstraints = this.hasConstraintForAllOperations(operationConstraintNodes);
        Assert.assertTrue((hasServiceConstraint || hasOperationConstraints ? 1 : 0) != 0, (String)"Constraint 'CountDefault' is missing. Expected is the constraint as service or operation constraints for operations 'GetFeature', 'GetFeatureWithLock' and 'GetPropetryValue'");
        if (hasServiceConstraint) {
            int countDefault = this.asInteger(serviceConstraintNode);
            Assert.assertTrue((countDefault >= 0 ? 1 : 0) != 0, (String)("CountDefault must be >= 0 but is " + countDefault));
        }
        if (hasOperationConstraints) {
            for (Map.Entry<String, Node> operationToConstraintEntry : operationConstraintNodes.entrySet()) {
                int countDefault = this.asInteger(operationToConstraintEntry.getValue());
                Assert.assertTrue((countDefault >= 0 ? 1 : 0) != 0, (String)("CountDefault for operation constraint " + operationToConstraintEntry.getKey() + " must be >= 0 but is " + countDefault));
            }
        }
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.3., S.31, Requirement 22")
    public void wfsCapabilitiesResolveTimeoutDefaultIs300() throws XPathFactoryConfigurationException, XPathExpressionException {
        String constraintName = "ResolveTimeoutDefault";
        String xPathServiceConstraint = String.format(XPATH_SERVICE_CONSTRAINT, constraintName);
        Node serviceConstraintNode = this.selectNode(xPathServiceConstraint);
        boolean hasServiceConstraint = serviceConstraintNode != null;
        Map<String, Node> operationConstraintNodes = this.retrieveOperationToConstraintForGetFeatureBundle(constraintName);
        boolean hasOperationConstraints = this.hasConstraintForAllOperations(operationConstraintNodes);
        Assert.assertTrue((hasServiceConstraint || hasOperationConstraints ? 1 : 0) != 0, (String)"Constraint 'ResolveTimeoutDefault' is missing. Expected is the constraint as service or operation constraints for operations 'GetFeature', 'GetFeatureWithLock' and 'GetPropetryValue'");
        if (hasServiceConstraint) {
            int resolveTimeOutDefault = this.asInteger(serviceConstraintNode);
            Assert.assertTrue((resolveTimeOutDefault == 300 ? 1 : 0) != 0, (String)("ResolveTimeoutDefault must be 300 but is " + resolveTimeOutDefault));
        }
        if (hasOperationConstraints) {
            for (Map.Entry<String, Node> operationToConstraintEntry : operationConstraintNodes.entrySet()) {
                int resolveTimeOutDefault = this.asInteger(operationToConstraintEntry.getValue());
                Assert.assertTrue((resolveTimeOutDefault == 300 ? 1 : 0) != 0, (String)("ResolveTimeoutDefault for operation constraint " + operationToConstraintEntry.getKey() + " must be 300 but is " + resolveTimeOutDefault));
            }
        }
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.3., S.31, Requirement 22")
    public void wfsCapabilitiesResolveLocalScopeIsAll() throws XPathFactoryConfigurationException, XPathExpressionException {
        String constraintName = "ResolveLocalScope";
        String xPathServiceConstraint = String.format(XPATH_SERVICE_CONSTRAINT, constraintName);
        Node serviceConstraintNode = this.selectNode(xPathServiceConstraint);
        boolean hasServiceConstraint = serviceConstraintNode != null;
        Map<String, Node> operationConstraintNodes = this.retrieveOperationToConstraintForGetFeatureBundle(constraintName);
        boolean hasOperationConstraints = this.hasConstraintForAllOperations(operationConstraintNodes);
        Assert.assertTrue((hasServiceConstraint || hasOperationConstraints ? 1 : 0) != 0, (String)"Constraint 'ResolveLocalScope' is missing. Expected is the constraint as service or operation constraints for operations 'GetFeature', 'GetFeatureWithLock' and 'GetPropetryValue'");
        if (hasServiceConstraint) {
            String resolveLocalScope = this.asString(serviceConstraintNode);
            Assert.assertNotNull((Object)resolveLocalScope, (String)"ResolveLocalScope is missing");
        }
        if (hasOperationConstraints) {
            for (Map.Entry<String, Node> operationToConstraintEntry : operationConstraintNodes.entrySet()) {
                String resolveLocalScope = this.asString(operationToConstraintEntry.getValue());
                Assert.assertNotNull((Object)resolveLocalScope, (String)("ResolveLocalScope for operation constraint " + operationToConstraintEntry.getKey() + " is missing"));
            }
        }
    }

    private Map<String, Node> retrieveOperationToConstraintForGetFeatureBundle(String constraintName) throws XPathFactoryConfigurationException, XPathExpressionException {
        return this.retrieveOperationToConstraint(constraintName, "GetFeature", "GetFeatureWithLock", "GetPropertyValue");
    }

    private Map<String, Node> retrieveOperationToConstraint(String constraintName, String ... operationNames) throws XPathFactoryConfigurationException, XPathExpressionException {
        HashMap<String, Node> operationConstraintNode = new HashMap<String, Node>();
        XPath xPath = this.createXPath();
        for (String operationName : operationNames) {
            String xPathOperationExpression = String.format(XPATH_OPERATION, operationName);
            Node operationNode = (Node)xPath.evaluate(xPathOperationExpression, this.wfsMetadata, XPathConstants.NODE);
            Node constraintValue = this.retrieveConstraintNodeFromOperationNode(constraintName, xPath, operationNode);
            operationConstraintNode.put(operationName, constraintValue);
        }
        return operationConstraintNode;
    }

    private Node retrieveConstraintNodeFromOperationNode(String constraintName, XPath xPath, Node operationNode) throws XPathExpressionException {
        if (operationNode != null) {
            String xPathConstraintExpression = String.format(XPATH_CONSTRAINT_PER_OPERATION, constraintName);
            return (Node)xPath.evaluate(xPathConstraintExpression, operationNode, XPathConstants.NODE);
        }
        return null;
    }

    private boolean hasConstraintForAllOperations(Map<String, Node> operationConstraintToNodes) {
        for (Map.Entry<String, Node> operationConstraintToNode : operationConstraintToNodes.entrySet()) {
            if (operationConstraintToNode.getValue() != null) continue;
            return false;
        }
        return true;
    }

    private Node selectNode(String xPathXml) throws XPathFactoryConfigurationException, XPathExpressionException {
        XPath xPath = this.createXPath();
        return (Node)xPath.evaluate(xPathXml, this.wfsMetadata, XPathConstants.NODE);
    }

    private int asInteger(Node xPathXml) throws XPathFactoryConfigurationException, XPathExpressionException {
        String value = this.asString(xPathXml);
        return Integer.parseInt(value);
    }

    private String asString(Node serviceConstraintNode) {
        String textContent = serviceConstraintNode.getTextContent();
        if (textContent == null || textContent.isEmpty()) {
            return null;
        }
        return textContent;
    }
}

